/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.DifficultyManager;
import com.example.examplemod.NightMobConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class WorldCreationDifficultyScreen
extends Screen {
    private final Screen parentScreen;
    private DifficultyManager.Difficulty selectedDifficulty = DifficultyManager.Difficulty.NOVICE;
    private List<Button> difficultyButtons = new ArrayList<Button>();
    private int currentPage = 0;
    private final int buttonsPerPage = 4;
    private int scrollOffset = 0;
    private final int maxScrollOffset = 150;

    public WorldCreationDifficultyScreen(Screen parentScreen) {
        super((Component)Component.m_237113_((String)"\u0412\u044b\u0431\u043e\u0440 \u0441\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u0438 Citadel Guard"));
        this.parentScreen = parentScreen;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.difficultyButtons.clear();
        int leftPanelX = 30;
        int leftPanelWidth = 180;
        int rightPanelX = leftPanelX + leftPanelWidth + 20;
        int rightPanelWidth = this.f_96543_ - rightPanelX - 30;
        int buttonStartY = 100;
        int buttonHeight = 24;
        int buttonSpacing = 6;
        int buttonWidth = leftPanelWidth - 20;
        String[] allDifficulties = new String[]{"\u00a7a\ud83c\udf31 \u041d\u041e\u0412\u0418\u0427\u041e\u041a", "\u00a7e\u2694 \u041e\u041f\u042b\u0422\u041d\u042b\u0419", "\u00a7c\ud83d\udc80 \u041c\u041e\u041d\u0421\u0422\u0420", "\u00a74\u2620 \u0421\u041c\u0415\u0420\u0422\u042c", "\u00a7d\ud83d\udd27 \u0422\u0415\u0421\u0422", "\u00a76\ud83d\udd25 \u0412 \u0420\u0410\u0417\u0420\u0410\u0411\u041e\u0422\u041a\u0415", "\u00a7b\u2744 \u0412 \u0420\u0410\u0417\u0420\u0410\u0411\u041e\u0422\u041a\u0415", "\u00a75\u2b50 \u0412 \u0420\u0410\u0417\u0420\u0410\u0411\u041e\u0422\u041a\u0415"};
        DifficultyManager.Difficulty[] realDifficulties = new DifficultyManager.Difficulty[]{DifficultyManager.Difficulty.NOVICE, DifficultyManager.Difficulty.EXPERIENCED, DifficultyManager.Difficulty.MONSTER, DifficultyManager.Difficulty.DEATH, DifficultyManager.Difficulty.TEST, null, null, null};
        int startIndex = this.currentPage * 4;
        int endIndex = Math.min(startIndex + 4, allDifficulties.length);
        for (int i = startIndex; i < endIndex; ++i) {
            DifficultyManager.Difficulty diff = i < realDifficulties.length ? realDifficulties[i] : null;
            Button diffButton = Button.m_253074_((Component)Component.m_237113_((String)allDifficulties[i]), button -> {
                if (diff != null) {
                    this.selectedDifficulty = diff;
                    this.updateButtonStates();
                }
            }).m_252987_(leftPanelX + 10, buttonStartY + (i - startIndex) * (buttonHeight + buttonSpacing), buttonWidth, buttonHeight).m_253136_();
            if (diff == null) {
                diffButton.f_93623_ = false;
            }
            this.difficultyButtons.add(diffButton);
            this.m_142416_((GuiEventListener)diffButton);
        }
        int pageButtonX = leftPanelX - 20;
        int pageButtonY = buttonStartY + 20;
        int pageButtonSize = 20;
        Button pageUpButton = Button.m_253074_((Component)Component.m_237113_((String)"\u00a77\u25b2"), button -> {
            if (this.currentPage > 0) {
                --this.currentPage;
                this.m_232761_();
            }
        }).m_252987_(pageButtonX, pageButtonY, pageButtonSize, pageButtonSize).m_253136_();
        pageUpButton.f_93623_ = this.currentPage > 0;
        this.m_142416_((GuiEventListener)pageUpButton);
        Button pageDownButton = Button.m_253074_((Component)Component.m_237113_((String)"\u00a77\u25bc"), button -> {
            if ((this.currentPage + 1) * 4 < allDifficulties.length) {
                ++this.currentPage;
                this.m_232761_();
            }
        }).m_252987_(pageButtonX, pageButtonY + pageButtonSize + 5, pageButtonSize, pageButtonSize).m_253136_();
        pageDownButton.f_93623_ = (this.currentPage + 1) * 4 < allDifficulties.length;
        this.m_142416_((GuiEventListener)pageDownButton);
        int controlButtonY = this.f_96544_ - 30;
        int controlButtonWidth = 100;
        Button confirmButton = Button.m_253074_((Component)Component.m_237113_((String)"\u00a7a\u00a7l\u041f\u041e\u0414\u0422\u0412\u0415\u0420\u0414\u0418\u0422\u042c"), button -> this.confirmSelection()).m_252987_(this.f_96543_ / 2 - controlButtonWidth - 10, controlButtonY, controlButtonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)confirmButton);
        Button cancelButton = Button.m_253074_((Component)Component.m_237113_((String)"\u00a7c\u00a7l\u041e\u0422\u041c\u0415\u041d\u0410"), button -> this.f_96541_.m_91152_(this.parentScreen)).m_252987_(this.f_96543_ / 2 + 10, controlButtonY, controlButtonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)cancelButton);
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        DifficultyManager.Difficulty[] realDifficulties = new DifficultyManager.Difficulty[]{DifficultyManager.Difficulty.NOVICE, DifficultyManager.Difficulty.EXPERIENCED, DifficultyManager.Difficulty.MONSTER, DifficultyManager.Difficulty.DEATH, DifficultyManager.Difficulty.TEST, null, null, null};
        int startIndex = this.currentPage * 4;
        for (int i = 0; i < this.difficultyButtons.size(); ++i) {
            Button button = this.difficultyButtons.get(i);
            int realIndex = startIndex + i;
            if (realIndex >= realDifficulties.length || realDifficulties[realIndex] == null) continue;
            boolean isSelected = realDifficulties[realIndex] == this.selectedDifficulty;
            button.f_93623_ = !isSelected;
        }
    }

    private void confirmSelection() {
        DifficultyManager.setWorldDifficulty(this.selectedDifficulty);
        this.f_96541_.m_91152_(this.parentScreen);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280137_(this.f_96547_, "\u00a76\u00a7l\u2699 \u041d\u0410\u0421\u0422\u0420\u041e\u0419\u041a\u0410 \u0421\u041b\u041e\u0416\u041d\u041e\u0421\u0422\u0418 CITADEL GUARD \u2699", this.f_96543_ / 2, 20, 0xFFFFFF);
        guiGraphics.m_280137_(this.f_96547_, "\u00a77\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0443\u0440\u043e\u0432\u0435\u043d\u044c \u0441\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u0438 \u0434\u043b\u044f \u0437\u0430\u0449\u0438\u0442\u044b \u0446\u0438\u0442\u0430\u0434\u0435\u043b\u0438", this.f_96543_ / 2, 35, 0xAAAAAA);
        int lineY = 55;
        guiGraphics.m_280509_(20, lineY, this.f_96543_ - 20, lineY + 1, -11184811);
        this.renderPanels(guiGraphics);
        this.renderPanelHeaders(guiGraphics);
        this.renderDifficultyDescription(guiGraphics);
        this.renderPageIndicator(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int leftPanelX = 30;
        int leftPanelWidth = 180;
        int rightPanelX = leftPanelX + leftPanelWidth + 20;
        int rightPanelWidth = this.f_96543_ - rightPanelX - 30;
        if (mouseX >= (double)rightPanelX && mouseX <= (double)(rightPanelX + rightPanelWidth)) {
            this.scrollOffset -= (int)(delta * 10.0);
            this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, 150));
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private void renderPanels(GuiGraphics guiGraphics) {
        int leftPanelX = 40;
        int leftPanelWidth = 220;
        int rightPanelX = leftPanelX + leftPanelWidth + 30;
        int rightPanelWidth = this.f_96543_ - rightPanelX - 40;
        int panelY = 70;
        int panelHeight = this.f_96544_ - 110;
        guiGraphics.m_280509_(leftPanelX, panelY, leftPanelX + leftPanelWidth, panelY + panelHeight, Integer.MIN_VALUE);
        this.renderPanelBorder(guiGraphics, leftPanelX, panelY, leftPanelWidth, panelHeight, -12303292);
        guiGraphics.m_280509_(rightPanelX, panelY, rightPanelX + rightPanelWidth, panelY + panelHeight, Integer.MIN_VALUE);
        this.renderPanelBorder(guiGraphics, rightPanelX, panelY, rightPanelWidth, panelHeight, -12303292);
    }

    private void renderPanelBorder(GuiGraphics guiGraphics, int x, int y, int width, int height, int color) {
        guiGraphics.m_280509_(x, y, x + width, y + 1, color);
        guiGraphics.m_280509_(x, y + height - 1, x + width, y + height, color);
        guiGraphics.m_280509_(x, y, x + 1, y + height, color);
        guiGraphics.m_280509_(x + width - 1, y, x + width, y + height, color);
    }

    private void renderPanelHeaders(GuiGraphics guiGraphics) {
        int leftPanelX = 40;
        int leftPanelWidth = 220;
        int rightPanelX = leftPanelX + leftPanelWidth + 30;
        guiGraphics.m_280488_(this.f_96547_, "\u00a7e\u00a7l\u0412\u042b\u0411\u041e\u0420 \u0421\u041b\u041e\u0416\u041d\u041e\u0421\u0422\u0418:", leftPanelX + 10, 80, 0xFFFFFF);
    }

    private void renderPageIndicator(GuiGraphics guiGraphics) {
    }

    private void renderDifficultyDescription(GuiGraphics guiGraphics) {
        String[] tips;
        String[] targetAudience;
        int leftPanelX = 40;
        int leftPanelWidth = 220;
        int rightPanelX = leftPanelX + leftPanelWidth + 30 + 10;
        int panelWidth = this.f_96543_ - rightPanelX - 50;
        int panelHeight = this.f_96544_ - 120;
        int clipY = 70;
        guiGraphics.m_280588_(rightPanelX - 5, clipY, rightPanelX + panelWidth, clipY + panelHeight);
        int startY = 80 - this.scrollOffset;
        int lineHeight = 11;
        int currentY = startY;
        for (String line : targetAudience = this.getDifficultyTargetAudience(this.selectedDifficulty)) {
            guiGraphics.m_280488_(this.f_96547_, line, rightPanelX, currentY, 0xFFFFFF);
            currentY += lineHeight + 1;
        }
        guiGraphics.m_280488_(this.f_96547_, "\u00a7e\u00a7l\u041a\u041e\u041b\u0418\u0427\u0415\u0421\u0422\u0412\u041e \u041c\u041e\u0411\u041e\u0412:", rightPanelX, currentY += 8, 0xFFFFFF);
        int night1 = NightMobConfig.getMobCountForNight(1, this.selectedDifficulty);
        int night25 = NightMobConfig.getMobCountForNight(25, this.selectedDifficulty);
        int night50 = NightMobConfig.getMobCountForNight(50, this.selectedDifficulty);
        int night100 = NightMobConfig.getMobCountForNight(100, this.selectedDifficulty);
        guiGraphics.m_280488_(this.f_96547_, "\u00a771-\u044f \u043d\u043e\u0447\u044c: \u00a7f" + night1 + " \u043c\u043e\u0431\u043e\u0432", rightPanelX, currentY += lineHeight + 3, 0xFFFFFF);
        guiGraphics.m_280488_(this.f_96547_, "\u00a7725-\u044f \u043d\u043e\u0447\u044c: \u00a7f" + night25 + " \u043c\u043e\u0431\u043e\u0432", rightPanelX, currentY += lineHeight + 1, 0xFFFFFF);
        guiGraphics.m_280488_(this.f_96547_, "\u00a7750-\u044f \u043d\u043e\u0447\u044c: \u00a7f" + night50 + " \u043c\u043e\u0431\u043e\u0432", rightPanelX, currentY += lineHeight + 1, 0xFFFFFF);
        String difficultyColor = this.getDifficultyColor(this.selectedDifficulty);
        guiGraphics.m_280488_(this.f_96547_, "\u00a77100-\u044f \u043d\u043e\u0447\u044c: " + difficultyColor + "\u00a7l" + String.format("%,d", night100) + " \u043c\u043e\u0431\u043e\u0432", rightPanelX, currentY += lineHeight + 1, 0xFFFFFF);
        guiGraphics.m_280488_(this.f_96547_, "\u00a7e\u00a7l\u0421\u041e\u0412\u0415\u0422\u042b:", rightPanelX, currentY += lineHeight + 8, 0xFFFFFF);
        currentY += lineHeight + 3;
        for (String tip : tips = this.getDifficultyTips(this.selectedDifficulty)) {
            guiGraphics.m_280488_(this.f_96547_, tip, rightPanelX, currentY, 0xFFFFFF);
            currentY += lineHeight + 1;
        }
        guiGraphics.m_280618_();
    }

    private String getDifficultyColor(DifficultyManager.Difficulty difficulty) {
        switch (difficulty) {
            case NOVICE: {
                return "\u00a7a";
            }
            case EXPERIENCED: {
                return "\u00a7e";
            }
            case MONSTER: {
                return "\u00a7c";
            }
            case DEATH: {
                return "\u00a74";
            }
            case TEST: {
                return "\u00a7d";
            }
        }
        return "\u00a7f";
    }

    private String getDifficultyIcon(DifficultyManager.Difficulty difficulty) {
        switch (difficulty) {
            case NOVICE: {
                return "\ud83c\udf31";
            }
            case EXPERIENCED: {
                return "\u2694";
            }
            case MONSTER: {
                return "\ud83d\udc80";
            }
            case DEATH: {
                return "\u2620";
            }
            case TEST: {
                return "\ud83d\udd27";
            }
        }
        return "?";
    }

    private String[] getDifficultyTargetAudience(DifficultyManager.Difficulty difficulty) {
        switch (difficulty) {
            case NOVICE: {
                return new String[]{"\u00a7a\u00a7l\u041f\u041e\u0414\u0425\u041e\u0414\u0418\u0422 \u0414\u041b\u042f:", "\u00a77\u2022 \u041d\u043e\u0432\u0438\u0447\u043a\u043e\u0432 \u0432 \u043c\u043e\u0434\u0435 Citadel Guard", "\u00a77\u2022 \u0418\u0433\u0440\u043e\u043a\u043e\u0432, \u0438\u0437\u0443\u0447\u0430\u044e\u0449\u0438\u0445 \u043c\u0435\u0445\u0430\u043d\u0438\u043a\u0438 \u0437\u0430\u0449\u0438\u0442\u044b", "\u00a77\u2022 \u0422\u0435\u0445, \u043a\u0442\u043e \u0445\u043e\u0447\u0435\u0442 \u0441\u043f\u043e\u043a\u043e\u0439\u043d\u043e \u043e\u0441\u0432\u043e\u0438\u0442\u044c\u0441\u044f", "\u00a77\u2022 \u041f\u0435\u0440\u0432\u043e\u0433\u043e \u043f\u0440\u043e\u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f \u043c\u043e\u0434\u0430"};
            }
            case EXPERIENCED: {
                return new String[]{"\u00a7e\u00a7l\u041f\u041e\u0414\u0425\u041e\u0414\u0418\u0422 \u0414\u041b\u042f:", "\u00a77\u2022 \u0418\u0433\u0440\u043e\u043a\u043e\u0432, \u0437\u043d\u0430\u043a\u043e\u043c\u044b\u0445 \u0441 \u043c\u043e\u0434\u043e\u043c", "\u00a77\u2022 \u0422\u0435\u0445, \u043a\u0442\u043e \u043e\u0441\u0432\u043e\u0438\u043b \u0431\u0430\u0437\u043e\u0432\u044b\u0435 \u043c\u0435\u0445\u0430\u043d\u0438\u043a\u0438", "\u00a77\u2022 \u041b\u044e\u0431\u0438\u0442\u0435\u043b\u0435\u0439 \u0441\u0431\u0430\u043b\u0430\u043d\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u0432\u044b\u0437\u043e\u0432\u0430", "\u00a77\u2022 \u0421\u0442\u0440\u0430\u0442\u0435\u0433\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f"};
            }
            case MONSTER: {
                return new String[]{"\u00a7c\u00a7l\u041f\u041e\u0414\u0425\u041e\u0414\u0418\u0422 \u0414\u041b\u042f:", "\u00a77\u2022 \u041e\u043f\u044b\u0442\u043d\u044b\u0445 \u0438\u0433\u0440\u043e\u043a\u043e\u0432 \u0432 \u0432\u044b\u0436\u0438\u0432\u0430\u043d\u0438\u0438", "\u00a77\u2022 \u041c\u0430\u0441\u0442\u0435\u0440\u043e\u0432 \u043e\u0431\u043e\u0440\u043e\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u0441\u0442\u0440\u0430\u0442\u0435\u0433\u0438\u0439", "\u00a77\u2022 \u0422\u0435\u0445, \u043a\u0442\u043e \u0438\u0449\u0435\u0442 \u0441\u0435\u0440\u044c\u0435\u0437\u043d\u044b\u0439 \u0432\u044b\u0437\u043e\u0432", "\u00a77\u2022 \u041b\u044e\u0431\u0438\u0442\u0435\u043b\u0435\u0439 \u0438\u043d\u0442\u0435\u043d\u0441\u0438\u0432\u043d\u043e\u0433\u043e \u0433\u0435\u0439\u043c\u043f\u043b\u0435\u044f"};
            }
            case DEATH: {
                return new String[]{"\u00a74\u00a7l\u041f\u041e\u0414\u0425\u041e\u0414\u0418\u0422 \u0414\u041b\u042f:", "\u00a77\u2022 \u042d\u043a\u0441\u043f\u0435\u0440\u0442\u043e\u0432 \u043c\u043e\u0434\u0430 Citadel Guard", "\u00a77\u2022 \u041c\u0430\u0441\u0442\u0435\u0440\u043e\u0432 \u0432\u044b\u0436\u0438\u0432\u0430\u043d\u0438\u044f \u0432 Minecraft", "\u00a77\u2022 \u0422\u0435\u0445, \u043a\u0442\u043e \u043f\u0440\u043e\u0448\u0435\u043b \u0432\u0441\u0435 \u0443\u0440\u043e\u0432\u043d\u0438", "\u00a77\u2022 \u0418\u0441\u043a\u0430\u0442\u0435\u043b\u0435\u0439 \u044d\u043a\u0441\u0442\u0440\u0435\u043c\u0430\u043b\u044c\u043d\u044b\u0445 \u0438\u0441\u043f\u044b\u0442\u0430\u043d\u0438\u0439"};
            }
            case TEST: {
                return new String[]{"\u00a7d\u00a7l\u041f\u041e\u0414\u0425\u041e\u0414\u0418\u0422 \u0414\u041b\u042f:", "\u00a77\u2022 \u0420\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u043e\u0432 \u0438 \u0442\u0435\u0441\u0442\u0438\u0440\u043e\u0432\u0449\u0438\u043a\u043e\u0432", "\u00a77\u2022 \u0418\u0437\u0443\u0447\u0435\u043d\u0438\u044f \u043c\u0435\u0445\u0430\u043d\u0438\u043a \u043c\u043e\u0434\u0430", "\u00a77\u2022 \u041e\u0442\u043b\u0430\u0434\u043a\u0438 \u0438 \u044d\u043a\u0441\u043f\u0435\u0440\u0438\u043c\u0435\u043d\u0442\u043e\u0432", "\u00a77\u2022 \u0421\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043a\u043e\u043d\u0442\u0435\u043d\u0442\u0430"};
            }
        }
        return new String[]{"\u00a77\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430."};
    }

    private String[] getDifficultyTips(DifficultyManager.Difficulty difficulty) {
        switch (difficulty) {
            case NOVICE: {
                return new String[]{"\u00a77\u2022 \u0421\u0442\u0440\u043e\u0439\u0442\u0435 \u0441\u0442\u0435\u043d\u044b \u0432\u043e\u043a\u0440\u0443\u0433 \u0431\u0430\u0437\u044b \u0441 \u043f\u0435\u0440\u0432\u043e\u0433\u043e \u0434\u043d\u044f", "\u00a77\u2022 \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0444\u0430\u043a\u0435\u043b\u044b \u0434\u043b\u044f \u043e\u0441\u0432\u0435\u0449\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0438\u043c\u0435\u0442\u0440\u0430", "\u00a77\u2022 \u0421\u043e\u0437\u0434\u0430\u0432\u0430\u0439\u0442\u0435 \u0437\u0430\u043f\u0430\u0441\u044b \u0435\u0434\u044b \u0438 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b\u043e\u0432", "\u00a77\u2022 \u0418\u0437\u0443\u0447\u0438\u0442\u0435 \u043a\u0440\u0430\u0444\u0442 \u0437\u0430\u0449\u0438\u0442\u043d\u044b\u0445 \u0431\u043b\u043e\u043a\u043e\u0432", "\u00a77\u2022 \u041d\u0435 \u0442\u043e\u0440\u043e\u043f\u0438\u0442\u0435\u0441\u044c - \u0443 \u0432\u0430\u0441 \u0435\u0441\u0442\u044c \u0432\u0440\u0435\u043c\u044f"};
            }
            case EXPERIENCED: {
                return new String[]{"\u00a77\u2022 \u041f\u043b\u0430\u043d\u0438\u0440\u0443\u0439\u0442\u0435 \u043e\u0431\u043e\u0440\u043e\u043d\u0443 \u0437\u0430\u0440\u0430\u043d\u0435\u0435", "\u00a77\u2022 \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u043b\u043e\u0432\u0443\u0448\u043a\u0438 \u0438 \u043c\u0435\u0445\u0430\u043d\u0438\u0437\u043c\u044b", "\u00a77\u2022 \u0421\u043e\u0437\u0434\u0430\u0432\u0430\u0439\u0442\u0435 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u043b\u0438\u043d\u0438\u0439 \u0437\u0430\u0449\u0438\u0442\u044b", "\u00a77\u2022 \u0418\u0437\u0443\u0447\u0438\u0442\u0435 \u043f\u0430\u0442\u0442\u0435\u0440\u043d\u044b \u0430\u0442\u0430\u043a \u043c\u043e\u0431\u043e\u0432", "\u00a77\u2022 \u0413\u043e\u0442\u043e\u0432\u044c\u0442\u0435\u0441\u044c \u043a \u043a\u0440\u043e\u0432\u0430\u0432\u044b\u043c \u043d\u043e\u0447\u0430\u043c"};
            }
            case MONSTER: {
                return new String[]{"\u00a77\u2022 \u0421\u0442\u0440\u043e\u0439\u0442\u0435 \u043c\u043d\u043e\u0433\u043e\u0443\u0440\u043e\u0432\u043d\u0435\u0432\u0443\u044e \u043e\u0431\u043e\u0440\u043e\u043d\u0443", "\u00a77\u2022 \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0432\u0441\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u0440\u0435\u0441\u0443\u0440\u0441\u044b", "\u00a77\u2022 \u0421\u043e\u0437\u0434\u0430\u0432\u0430\u0439\u0442\u0435 \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u044b", "\u00a77\u2022 \u041f\u043b\u0430\u043d\u0438\u0440\u0443\u0439\u0442\u0435 \u043a\u0430\u0436\u0434\u0443\u044e \u043d\u043e\u0447\u044c \u043a\u0430\u043a \u0431\u0438\u0442\u0432\u0443", "\u00a77\u2022 \u0418\u0437\u0443\u0447\u0438\u0442\u0435 \u043f\u0440\u043e\u0434\u0432\u0438\u043d\u0443\u0442\u044b\u0435 \u0441\u0442\u0440\u0430\u0442\u0435\u0433\u0438\u0438"};
            }
            case DEATH: {
                return new String[]{"\u00a77\u2022 \u041a\u0430\u0436\u0434\u044b\u0439 \u0431\u043b\u043e\u043a \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0437\u0430\u0449\u0438\u0449\u0435\u043d", "\u00a77\u2022 \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0432\u0441\u0435 \u043c\u0435\u0445\u0430\u043d\u0438\u043a\u0438 \u043c\u043e\u0434\u0430", "\u00a77\u2022 \u0421\u043e\u0437\u0434\u0430\u0432\u0430\u0439\u0442\u0435 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u044b\u0435 \u043f\u043b\u0430\u043d\u044b", "\u00a77\u2022 \u0413\u043e\u0442\u043e\u0432\u044c\u0442\u0435\u0441\u044c \u043a \u043d\u0435\u043f\u0440\u0435\u0440\u044b\u0432\u043d\u044b\u043c \u0430\u0442\u0430\u043a\u0430\u043c", "\u00a77\u2022 \u0423\u0434\u0430\u0447\u0438 - \u043e\u043d\u0430 \u0432\u0430\u043c \u043f\u043e\u043d\u0430\u0434\u043e\u0431\u0438\u0442\u0441\u044f!"};
            }
            case TEST: {
                return new String[]{"\u00a77\u2022 \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u043a\u043e\u043c\u0430\u043d\u0434\u044b \u0434\u043b\u044f \u0442\u0435\u0441\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", "\u00a77\u2022 \u042d\u043a\u0441\u043f\u0435\u0440\u0438\u043c\u0435\u043d\u0442\u0438\u0440\u0443\u0439\u0442\u0435 \u0441 \u043c\u0435\u0445\u0430\u043d\u0438\u043a\u0430\u043c\u0438", "\u00a77\u2022 \u0418\u0437\u0443\u0447\u0430\u0439\u0442\u0435 \u043f\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u0435 \u043c\u043e\u0431\u043e\u0432", "\u00a77\u2022 \u0422\u0435\u0441\u0442\u0438\u0440\u0443\u0439\u0442\u0435 \u0440\u0430\u0437\u043b\u0438\u0447\u043d\u044b\u0435 \u0441\u0442\u0440\u0430\u0442\u0435\u0433\u0438\u0438", "\u00a77\u2022 \u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0438\u0440\u0443\u0439\u0442\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043d\u044b\u0435 \u0431\u0430\u0433\u0438"};
            }
        }
        return new String[]{"\u00a77\u0421\u043e\u0432\u0435\u0442\u044b \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b."};
    }

    public boolean m_7043_() {
        return false;
    }
}

