/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.ProtectionZone;
import com.example.examplemod.SurvivalManager;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(modid="citadelguard", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ZoneBorderRenderer {
    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        ClientLevel level = minecraft.f_91073_;
        if (player == null || level == null) {
            return;
        }
        SurvivalManager manager = SurvivalManager.get((Level)level);
        if (manager == null) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
        Vec3 cameraPos = event.getCamera().m_90583_();
        for (ProtectionZone zone : manager.getProtectionZones()) {
            ZoneBorderRenderer.renderZoneBorder(poseStack, (MultiBufferSource)bufferSource, zone, cameraPos);
        }
    }

    private static void renderZoneBorder(PoseStack poseStack, MultiBufferSource bufferSource, ProtectionZone zone, Vec3 cameraPos) {
        BlockPos center = zone.getCenterBlock();
        double offsetX = (double)center.m_123341_() - cameraPos.f_82479_;
        double offsetY = (double)center.m_123342_() - cameraPos.f_82480_ + 0.1;
        double offsetZ = (double)center.m_123343_() - cameraPos.f_82481_;
        poseStack.m_85836_();
        poseStack.m_85837_(offsetX, offsetY, offsetZ);
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110504_());
        float r = 1.0f;
        float g = 0.0f;
        float b = 0.0f;
        float a = 0.9f;
        ZoneBorderRenderer.drawSquare10x10Border(poseStack, vertexConsumer, r, g, b, a);
        poseStack.m_85849_();
    }

    private static void drawSquare10x10Border(PoseStack poseStack, VertexConsumer vertexConsumer, float r, float g, float b, float a) {
        float minX = -5.0f;
        float maxX = 5.0f;
        float minZ = -5.0f;
        float maxZ = 5.0f;
        float y = 0.0f;
        ZoneBorderRenderer.addLine(poseStack, vertexConsumer, minX, y, minZ, maxX, y, minZ, r, g, b, a);
        ZoneBorderRenderer.addLine(poseStack, vertexConsumer, maxX, y, minZ, maxX, y, maxZ, r, g, b, a);
        ZoneBorderRenderer.addLine(poseStack, vertexConsumer, maxX, y, maxZ, minX, y, maxZ, r, g, b, a);
        ZoneBorderRenderer.addLine(poseStack, vertexConsumer, minX, y, maxZ, minX, y, minZ, r, g, b, a);
        ZoneBorderRenderer.addLine(poseStack, vertexConsumer, minX, y, minZ, maxX, y, maxZ, r, g, b, a * 0.4f);
        ZoneBorderRenderer.addLine(poseStack, vertexConsumer, maxX, y, minZ, minX, y, maxZ, r, g, b, a * 0.4f);
        ZoneBorderRenderer.addLine(poseStack, vertexConsumer, 0.0f, y, minZ, 0.0f, y, maxZ, r, g, b, a * 0.5f);
        ZoneBorderRenderer.addLine(poseStack, vertexConsumer, minX, y, 0.0f, maxX, y, 0.0f, r, g, b, a * 0.5f);
        float quarterX1 = -2.5f;
        float quarterX2 = 2.5f;
        float quarterZ1 = -2.5f;
        float quarterZ2 = 2.5f;
        ZoneBorderRenderer.addLine(poseStack, vertexConsumer, quarterX1, y, minZ, quarterX1, y, maxZ, r, g, b, a * 0.3f);
        ZoneBorderRenderer.addLine(poseStack, vertexConsumer, quarterX2, y, minZ, quarterX2, y, maxZ, r, g, b, a * 0.3f);
        ZoneBorderRenderer.addLine(poseStack, vertexConsumer, minX, y, quarterZ1, maxX, y, quarterZ1, r, g, b, a * 0.3f);
        ZoneBorderRenderer.addLine(poseStack, vertexConsumer, minX, y, quarterZ2, maxX, y, quarterZ2, r, g, b, a * 0.3f);
    }

    private static void addLine(PoseStack poseStack, VertexConsumer vertexConsumer, float x1, float y1, float z1, float x2, float y2, float z2, float r, float g, float b, float a) {
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        vertexConsumer.m_252986_(matrix, x1, y1, z1).m_85950_(r, g, b, a).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, x2, y2, z2).m_85950_(r, g, b, a).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

