/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.client.gui;

import com.example.examplemod.DifficultyManager;
import com.example.examplemod.NightMobConfig;
import com.example.examplemod.client.CitadelGuardConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class CitadelGuardDifficultyScreen
extends Screen {
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"citadelguard", (String)"textures/gui/difficulty_selection.png");
    private final Screen parentScreen;
    private DifficultyManager.Difficulty selectedDifficulty;
    private static final int GUI_WIDTH = 400;
    private static final int GUI_HEIGHT = 300;
    private int guiLeft;
    private int guiTop;

    public CitadelGuardDifficultyScreen(Screen parentScreen) {
        super((Component)Component.m_237113_((String)"Citadel Guard - \u0412\u044b\u0431\u043e\u0440 \u0441\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u0438"));
        this.parentScreen = parentScreen;
        this.selectedDifficulty = DifficultyManager.Difficulty.NOVICE;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.guiLeft = (this.f_96543_ - 400) / 2;
        this.guiTop = (this.f_96544_ - 300) / 2;
        this.createDifficultyButtons();
        this.createControlButtons();
    }

    private void createDifficultyButtons() {
        int buttonWidth = 150;
        int buttonHeight = 20;
        int startY = this.guiTop + 50;
        int spacing = 25;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u2b50 \u041d\u043e\u0432\u0438\u0447\u043e\u043a"), button -> this.selectDifficulty(DifficultyManager.Difficulty.NOVICE)).m_252987_(this.guiLeft + 20, startY, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u2694 \u041e\u043f\u044b\u0442\u043d\u044b\u0439"), button -> this.selectDifficulty(DifficultyManager.Difficulty.EXPERIENCED)).m_252987_(this.guiLeft + 20, startY + spacing, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\ud83d\udd25 \u041c\u043e\u043d\u0441\u0442\u0440"), button -> this.selectDifficulty(DifficultyManager.Difficulty.MONSTER)).m_252987_(this.guiLeft + 20, startY + spacing * 2, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\ud83d\udc80 \u0421\u043c\u0435\u0440\u0442\u044c"), button -> this.selectDifficulty(DifficultyManager.Difficulty.DEATH)).m_252987_(this.guiLeft + 20, startY + spacing * 3, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\ud83d\udd27 \u0422\u0435\u0441\u0442"), button -> this.selectDifficulty(DifficultyManager.Difficulty.TEST)).m_252987_(this.guiLeft + 20, startY + spacing * 4, buttonWidth, buttonHeight).m_253136_());
    }

    private void createControlButtons() {
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u2713 \u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u044c"), button -> this.confirmSelection()).m_252987_(this.guiLeft + 50, this.guiTop + 300 - 50, 100, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u2717 \u041e\u0442\u043c\u0435\u043d\u0430"), button -> this.f_96541_.m_91152_(this.parentScreen)).m_252987_(this.guiLeft + 250, this.guiTop + 300 - 50, 100, 20).m_253136_());
    }

    private void selectDifficulty(DifficultyManager.Difficulty difficulty) {
        this.selectedDifficulty = difficulty;
    }

    private void confirmSelection() {
        CitadelGuardConfig.setSelectedDifficulty(this.selectedDifficulty);
        this.f_96541_.m_91152_(this.parentScreen);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        this.renderGuiBackground(guiGraphics);
        this.renderTitle(guiGraphics);
        this.renderDifficultyDescription(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void renderGuiBackground(GuiGraphics guiGraphics) {
        guiGraphics.m_280509_(this.guiLeft, this.guiTop, this.guiLeft + 400, this.guiTop + 300, -1072689136);
        guiGraphics.m_280509_(this.guiLeft - 1, this.guiTop - 1, this.guiLeft + 400 + 1, this.guiTop, -1);
        guiGraphics.m_280509_(this.guiLeft - 1, this.guiTop + 300, this.guiLeft + 400 + 1, this.guiTop + 300 + 1, -1);
        guiGraphics.m_280509_(this.guiLeft - 1, this.guiTop, this.guiLeft, this.guiTop + 300, -1);
        guiGraphics.m_280509_(this.guiLeft + 400, this.guiTop, this.guiLeft + 400 + 1, this.guiTop + 300, -1);
    }

    private void renderTitle(GuiGraphics guiGraphics) {
        MutableComponent title = Component.m_237113_((String)"\ud83c\udff0 Citadel Guard - \u0412\u044b\u0431\u043e\u0440 \u0441\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u0438");
        int titleWidth = this.f_96547_.m_92852_((FormattedText)title);
        int titleX = this.guiLeft + (400 - titleWidth) / 2;
        int titleY = this.guiTop + 15;
        guiGraphics.m_280430_(this.f_96547_, (Component)title, titleX, titleY, 0xFFFFFF);
    }

    private void renderDifficultyDescription(GuiGraphics guiGraphics) {
        int descX = this.guiLeft + 200;
        int descY = this.guiTop + 50;
        int lineHeight = 12;
        MutableComponent selectedTitle = Component.m_237113_((String)("\u0412\u044b\u0431\u0440\u0430\u043d\u043e: " + this.selectedDifficulty.getDisplayName()));
        guiGraphics.m_280430_(this.f_96547_, (Component)selectedTitle, descX, descY, 0xFFFF00);
        List<String> description = this.getDifficultyDescription(this.selectedDifficulty);
        for (int i = 0; i < description.size(); ++i) {
            MutableComponent line = Component.m_237113_((String)description.get(i));
            guiGraphics.m_280430_(this.f_96547_, (Component)line, descX, descY + 20 + i * lineHeight, 0xCCCCCC);
        }
    }

    private List<String> getDifficultyDescription(DifficultyManager.Difficulty difficulty) {
        ArrayList<String> description = new ArrayList<String>();
        int night1 = NightMobConfig.getMobCountForNight(1, difficulty);
        int night50 = NightMobConfig.getMobCountForNight(50, difficulty);
        int night100 = NightMobConfig.getMobCountForNight(100, difficulty);
        switch (difficulty) {
            case NOVICE: {
                description.add("\u00a7a\u2022 \u0418\u0434\u0435\u0430\u043b\u044c\u043d\u043e \u0434\u043b\u044f \u043d\u043e\u0432\u0438\u0447\u043a\u043e\u0432");
                description.add("\u00a7a\u2022 \u0418\u0437\u0443\u0447\u0435\u043d\u0438\u0435 \u043e\u0441\u043d\u043e\u0432 \u043e\u0431\u043e\u0440\u043e\u043d\u044b");
                description.add("\u00a7a\u2022 \u041c\u044f\u0433\u043a\u043e\u0435 \u0432\u0432\u0435\u0434\u0435\u043d\u0438\u0435 \u0432 \u043c\u0435\u0445\u0430\u043d\u0438\u043a\u0438");
                description.add("");
                description.add("\u00a77\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043c\u043e\u0431\u043e\u0432:");
                description.add("\u00a7f\u2022 1-\u044f \u043d\u043e\u0447\u044c: \u00a7a" + night1);
                description.add("\u00a7f\u2022 50-\u044f \u043d\u043e\u0447\u044c: \u00a7a" + night50);
                description.add("\u00a7f\u2022 100-\u044f \u043d\u043e\u0447\u044c: \u00a7a\u00a7l" + String.format("%,d", night100));
                break;
            }
            case EXPERIENCED: {
                description.add("\u00a7e\u2022 \u0421\u0431\u0430\u043b\u0430\u043d\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0432\u044b\u0437\u043e\u0432");
                description.add("\u00a7e\u2022 \u0414\u043b\u044f \u043e\u0441\u0432\u043e\u0438\u0432\u0448\u0438\u0445 \u043e\u0441\u043d\u043e\u0432\u044b");
                description.add("\u00a7e\u2022 \u0422\u0440\u0435\u0431\u0443\u0435\u0442 \u0441\u0442\u0440\u0430\u0442\u0435\u0433\u0438\u0438");
                description.add("");
                description.add("\u00a77\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043c\u043e\u0431\u043e\u0432:");
                description.add("\u00a7f\u2022 1-\u044f \u043d\u043e\u0447\u044c: \u00a7e" + night1);
                description.add("\u00a7f\u2022 50-\u044f \u043d\u043e\u0447\u044c: \u00a7e" + night50);
                description.add("\u00a7f\u2022 100-\u044f \u043d\u043e\u0447\u044c: \u00a7e\u00a7l" + String.format("%,d", night100));
                break;
            }
            case MONSTER: {
                description.add("\u00a7c\u2022 \u0421\u0435\u0440\u044c\u0435\u0437\u043d\u043e\u0435 \u0438\u0441\u043f\u044b\u0442\u0430\u043d\u0438\u0435");
                description.add("\u00a7c\u2022 \u0414\u043b\u044f \u043e\u043f\u044b\u0442\u043d\u044b\u0445 \u0438\u0433\u0440\u043e\u043a\u043e\u0432");
                description.add("\u00a7c\u2022 \u0422\u0440\u0435\u0431\u0443\u0435\u0442 \u043c\u0430\u0441\u0442\u0435\u0440\u0441\u0442\u0432\u0430");
                description.add("");
                description.add("\u00a77\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043c\u043e\u0431\u043e\u0432:");
                description.add("\u00a7f\u2022 1-\u044f \u043d\u043e\u0447\u044c: \u00a7c" + night1);
                description.add("\u00a7f\u2022 50-\u044f \u043d\u043e\u0447\u044c: \u00a7c" + night50);
                description.add("\u00a7f\u2022 100-\u044f \u043d\u043e\u0447\u044c: \u00a7c\u00a7l" + String.format("%,d", night100));
                break;
            }
            case DEATH: {
                description.add("\u00a74\u2022 \u042d\u043a\u0441\u0442\u0440\u0435\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0441\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u044c");
                description.add("\u00a74\u2022 \u0414\u043b\u044f \u043c\u0430\u0441\u0442\u0435\u0440\u043e\u0432");
                description.add("\u00a74\u2022 \u041a\u0430\u0436\u0434\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043a\u0440\u0438\u0442\u0438\u0447\u043d\u0430");
                description.add("");
                description.add("\u00a77\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043c\u043e\u0431\u043e\u0432:");
                description.add("\u00a7f\u2022 1-\u044f \u043d\u043e\u0447\u044c: \u00a74" + night1);
                description.add("\u00a7f\u2022 50-\u044f \u043d\u043e\u0447\u044c: \u00a74" + night50);
                description.add("\u00a7f\u2022 100-\u044f \u043d\u043e\u0447\u044c: \u00a74\u00a7l" + String.format("%,d", night100));
                break;
            }
            case TEST: {
                description.add("\u00a7d\u2022 \u0420\u0435\u0436\u0438\u043c \u0434\u043b\u044f \u0442\u0435\u0441\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
                description.add("\u00a7d\u2022 \u0414\u043b\u044f \u0438\u0437\u0443\u0447\u0435\u043d\u0438\u044f \u043c\u0435\u0445\u0430\u043d\u0438\u043a");
                description.add("\u00a7d\u2022 \u0414\u043e\u0441\u0442\u0443\u043f \u043a \u0442\u0435\u0441\u0442-\u0444\u0443\u043d\u043a\u0446\u0438\u044f\u043c");
                description.add("");
                description.add("\u00a77\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043c\u043e\u0431\u043e\u0432:");
                description.add("\u00a7f\u2022 1-\u044f \u043d\u043e\u0447\u044c: \u00a7d" + night1);
                description.add("\u00a7f\u2022 50-\u044f \u043d\u043e\u0447\u044c: \u00a7d" + night50);
                description.add("\u00a7f\u2022 100-\u044f \u043d\u043e\u0447\u044c: \u00a7d\u00a7l" + String.format("%,d", night100));
            }
        }
        return description;
    }

    public boolean m_7043_() {
        return false;
    }
}

