/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.client.gui;

import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ResourceUpgradeScreen
extends Screen {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"citadelguard", (String)"textures/gui/demos.png");
    private final Screen parentScreen;
    private int guiLeft;
    private int guiTop;
    private final int guiWidth = 256;
    private final int guiHeight = 166;
    private int selectedButton = -1;
    private static final ItemData[] ITEM_DATA = new ItemData[]{new ItemData(Items.f_42416_, "\u0416\u0435\u043b\u0435\u0437\u043d\u044b\u0439 \u0441\u043b\u0438\u0442\u043e\u043a", 5, "\u00a77\u0411\u0430\u0437\u043e\u0432\u044b\u0439 \u0440\u0435\u0441\u0443\u0440\u0441 \u0434\u043b\u044f \u0437\u0430\u0449\u0438\u0442\u044b"), new ItemData(Items.f_42417_, "\u0417\u043e\u043b\u043e\u0442\u043e\u0439 \u0441\u043b\u0438\u0442\u043e\u043a", 8, "\u00a7e\u0423\u043b\u0443\u0447\u0448\u0435\u043d\u043d\u0430\u044f \u0437\u0430\u0449\u0438\u0442\u0430 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0438"), new ItemData(Items.f_42415_, "\u0410\u043b\u043c\u0430\u0437", 15, "\u00a7b\u041c\u043e\u0449\u043d\u0430\u044f \u0437\u0430\u0449\u0438\u0442\u0430 \u043e\u0442 \u043c\u043e\u0431\u043e\u0432"), new ItemData(Items.f_42616_, "\u0418\u0437\u0443\u043c\u0440\u0443\u0434", 12, "\u00a7a\u0422\u043e\u0440\u0433\u043e\u0432\u044b\u0439 \u0440\u0435\u0441\u0443\u0440\u0441 \u0437\u0430\u0449\u0438\u0442\u044b"), new ItemData(Items.f_42418_, "\u041d\u0435\u0437\u0435\u0440\u0438\u0442\u043e\u0432\u044b\u0439 \u0441\u043b\u0438\u0442\u043e\u043a", 25, "\u00a75\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0437\u0430\u0449\u0438\u0442\u0430"), new ItemData(Items.f_42451_, "\u041a\u0440\u0430\u0441\u043d\u0430\u044f \u043f\u044b\u043b\u044c", 3, "\u00a7c\u042d\u043d\u0435\u0440\u0433\u0438\u044f \u0434\u043b\u044f \u0437\u0430\u0449\u0438\u0442\u043d\u044b\u0445 \u0441\u0438\u0441\u0442\u0435\u043c"), new ItemData(Items.f_42534_, "\u041b\u0430\u0437\u0443\u0440\u0438\u0442", 4, "\u00a79\u041c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u0437\u0430\u0449\u0438\u0442\u0430"), new ItemData(Items.f_42692_, "\u041a\u0432\u0430\u0440\u0446", 6, "\u00a7f\u0427\u0438\u0441\u0442\u0430\u044f \u044d\u043d\u0435\u0440\u0433\u0438\u044f \u0437\u0430\u0449\u0438\u0442\u044b"), new ItemData(Items.f_42413_, "\u0423\u0433\u043e\u043b\u044c", 2, "\u00a78\u0411\u0430\u0437\u043e\u0432\u043e\u0435 \u0442\u043e\u043f\u043b\u0438\u0432\u043e \u0437\u0430\u0449\u0438\u0442\u044b")};

    public ResourceUpgradeScreen(Screen parentScreen) {
        super((Component)Component.m_237113_((String)"\u0422\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u044f \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432"));
        this.parentScreen = parentScreen;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.guiLeft = (this.f_96543_ - this.guiWidth) / 2;
        this.guiTop = (this.f_96544_ - this.guiHeight) / 2;
        int[][] buttonCoords = new int[][]{{10, 15, 40, 45}, {60, 15, 90, 45}, {110, 15, 140, 45}, {10, 65, 40, 95}, {60, 65, 90, 95}, {110, 65, 140, 95}, {10, 115, 40, 145}, {60, 115, 90, 145}, {110, 115, 140, 145}};
        for (int i = 0; i < Math.min(buttonCoords.length, ITEM_DATA.length); ++i) {
            int buttonIndex = i;
            int[] coords = buttonCoords[i];
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)""), button -> this.selectButton(buttonIndex)).m_252987_(this.guiLeft + coords[0], this.guiTop + coords[1], coords[2] - coords[0], coords[3] - coords[1]).m_253136_());
        }
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u2190 \u041d\u0430\u0437\u0430\u0434"), button -> this.f_96541_.m_91152_(this.parentScreen)).m_252987_(this.guiLeft + 10, this.guiTop + this.guiHeight + 10, 80, 20).m_253136_());
    }

    private void selectButton(int buttonIndex) {
        this.selectedButton = buttonIndex;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280218_(TEXTURE, this.guiLeft, this.guiTop, 0, 0, this.guiWidth, this.guiHeight);
        this.renderItemIcons(guiGraphics);
        this.renderDescription(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void renderItemIcons(GuiGraphics guiGraphics) {
        int[][] buttonCoords = new int[][]{{10, 15, 40, 45}, {60, 15, 90, 45}, {110, 15, 140, 45}, {10, 65, 40, 95}, {60, 65, 90, 95}, {110, 65, 140, 95}, {10, 115, 40, 145}, {60, 115, 90, 145}, {110, 115, 140, 145}};
        for (int i = 0; i < Math.min(buttonCoords.length, ITEM_DATA.length); ++i) {
            int[] coords = buttonCoords[i];
            ItemData data = ITEM_DATA[i];
            int iconX = this.guiLeft + coords[0] + (coords[2] - coords[0] - 16) / 2;
            int iconY = this.guiTop + coords[1] + (coords[3] - coords[1] - 16) / 2;
            ItemStack itemStack = new ItemStack((ItemLike)data.item);
            guiGraphics.m_280480_(itemStack, iconX, iconY);
        }
    }

    private void renderDescription(GuiGraphics guiGraphics) {
        int descX = this.guiLeft + 162;
        int descY = this.guiTop + 9;
        int descWidth = 64;
        int descHeight = 146;
        int maxX = this.guiLeft + 226;
        int maxY = this.guiTop + 155;
        if (this.selectedButton >= 0 && this.selectedButton < ITEM_DATA.length) {
            String[] lines;
            ItemData data = ITEM_DATA[this.selectedButton];
            int currentY = descY + 2;
            String title = data.name;
            if (this.f_96547_.m_92895_(title) > descWidth - 4) {
                title = this.trimTextToWidth(title, descWidth - 4);
            }
            if (currentY + 9 <= maxY) {
                guiGraphics.m_280056_(this.f_96547_, "\u00a76" + title, descX + 2, currentY, 0xFFFFFF, false);
                currentY += 12;
            }
            if (currentY + 9 <= maxY) {
                guiGraphics.m_280056_(this.f_96547_, "\u00a7e\u0422\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u044f:", descX + 2, currentY, 0xFFFFFF, false);
                currentY += 10;
            }
            if (currentY + 9 <= maxY) {
                guiGraphics.m_280056_(this.f_96547_, "\u00a7a" + data.territory + " \u0431\u043b\u043e\u043a\u043e\u0432", descX + 2, currentY, 0xFFFFFF, false);
                currentY += 12;
            }
            if (currentY + 9 <= maxY) {
                guiGraphics.m_280056_(this.f_96547_, "\u00a77\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435:", descX + 2, currentY, 0xFFFFFF, false);
                currentY += 10;
            }
            for (String line : lines = this.wrapTextStrict(data.description, descWidth - 4)) {
                if (currentY + 9 <= maxY) {
                    guiGraphics.m_280056_(this.f_96547_, line, descX + 2, currentY, 0xFFFFFF, false);
                    currentY += 9;
                    continue;
                }
                break;
            }
        } else {
            int currentY = descY + 2;
            if (currentY + 9 <= maxY) {
                guiGraphics.m_280056_(this.f_96547_, "\u00a77\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435", descX + 2, currentY, 0xAAAAAA, false);
                currentY += 10;
            }
            if (currentY + 9 <= maxY) {
                guiGraphics.m_280056_(this.f_96547_, "\u00a77\u043f\u0440\u0435\u0434\u043c\u0435\u0442", descX + 2, currentY, 0xAAAAAA, false);
                currentY += 10;
            }
            if (currentY + 9 <= maxY) {
                guiGraphics.m_280056_(this.f_96547_, "\u00a77\u0434\u043b\u044f \u0438\u043d\u0444\u043e", descX + 2, currentY, 0xAAAAAA, false);
            }
        }
    }

    private String[] wrapTextStrict(String text, int maxWidth) {
        String[] words = text.split(" ");
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            String testLine;
            String cleanWord = word.replaceAll("\u00a7[0-9a-fk-or]", "");
            String string = testLine = currentLine.length() == 0 ? cleanWord : String.valueOf(currentLine) + " " + cleanWord;
            if (this.f_96547_.m_92895_(testLine) <= maxWidth) {
                if (currentLine.length() == 0) {
                    currentLine = new StringBuilder(word);
                    continue;
                }
                currentLine.append(" ").append(word);
                continue;
            }
            if (currentLine.length() > 0) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder(word);
                continue;
            }
            lines.add(this.trimTextToWidth(word, maxWidth));
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines.toArray(new String[0]);
    }

    private String trimTextToWidth(String text, int maxWidth) {
        if (this.f_96547_.m_92895_(text) <= maxWidth) {
            return text;
        }
        String cleanText = text.replaceAll("\u00a7[0-9a-fk-or]", "");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < cleanText.length(); ++i) {
            String testText = result.toString() + cleanText.charAt(i);
            if (this.f_96547_.m_92895_(testText) > maxWidth - 6) {
                result.append("...");
                break;
            }
            result.append(cleanText.charAt(i));
        }
        return result.toString();
    }

    public boolean m_7043_() {
        return false;
    }

    private static class ItemData {
        final Item item;
        final String name;
        final int territory;
        final String description;

        ItemData(Item item, String name, int territory, String description) {
            this.item = item;
            this.name = name;
            this.territory = territory;
            this.description = description;
        }
    }
}

