/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.network;

import com.example.examplemod.DifficultyManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class SetDifficultyPacket {
    private final DifficultyManager.Difficulty difficulty;

    public SetDifficultyPacket(DifficultyManager.Difficulty difficulty) {
        this.difficulty = difficulty;
    }

    public static void encode(SetDifficultyPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.difficulty.ordinal());
    }

    public static SetDifficultyPacket decode(FriendlyByteBuf buffer) {
        int difficultyOrdinal = buffer.readInt();
        DifficultyManager.Difficulty difficulty = DifficultyManager.Difficulty.values()[difficultyOrdinal];
        return new SetDifficultyPacket(difficulty);
    }

    public static void handle(SetDifficultyPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            try {
                Level patt1354$temp;
                ServerPlayer player = context.getSender();
                if (player != null && (patt1354$temp = player.m_9236_()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)patt1354$temp;
                    if (player.f_8906_ == null) {
                        return;
                    }
                    DifficultyManager.setSelectedDifficulty(packet.difficulty, player);
                }
            }
            catch (Exception e) {
                System.err.println("[CitadelGuard] Error handling SetDifficultyPacket: " + e.getMessage());
            }
        });
        context.setPacketHandled(true);
    }
}

