/*
 * Decompiled with CFR 0.152.
 */
package yaboichips.cwt.common;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;

public class CheeseChunkGenerator
extends NoiseBasedChunkGenerator {
    public static final Codec<CheeseChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(g -> g.f_62137_), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(g -> g.f_64318_)).apply((Applicative)instance, CheeseChunkGenerator::new));

    public CheeseChunkGenerator(BiomeSource biomeSource, Holder<NoiseGeneratorSettings> settings) {
        super(biomeSource, settings);
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    public ChunkAccess m_224284_(Blender p_224285_, StructureManager p_224286_, RandomState randomState, ChunkAccess chunk, int p_224289_, int p_224290_) {
        ChunkPos chunkPos = chunk.m_7697_();
        int chunkMinX = chunkPos.m_45604_();
        int chunkMinZ = chunkPos.m_45605_();
        int minY = chunk.m_141937_();
        int maxY = chunk.m_151558_();
        double densityScale = 1.0;
        double caveThreshold = -0.1;
        for (int localX = 0; localX < 16; ++localX) {
            for (int localZ = 0; localZ < 16; ++localZ) {
                int worldX = chunkMinX + localX;
                int worldZ = chunkMinZ + localZ;
                for (int worldY = minY; worldY < maxY; ++worldY) {
                    double caveNoise = randomState.m_224560_(Noises.f_189246_).m_75380_((double)worldX, (double)worldY, (double)worldZ) * densityScale;
                    BlockState state = caveNoise < caveThreshold ? Blocks.f_50069_.m_49966_() : Blocks.f_50016_.m_49966_();
                    int sectionIndex = chunk.m_151564_(worldY);
                    LevelChunkSection section = chunk.m_183278_(sectionIndex);
                    int xInSection = localX & 0xF;
                    int yInSection = worldY & 0xF;
                    int zInSection = localZ & 0xF;
                    section.m_62991_(xInSection, yInSection, zInSection, state, false);
                }
            }
        }
        return chunk;
    }
}

