/*
 * Decompiled with CFR 0.152.
 */
package yaboichips.cwt.common;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;

public class ChunkedChunkGenerator
extends NoiseBasedChunkGenerator {
    public static final Codec<ChunkedChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(g -> g.f_62137_), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(g -> g.f_64318_)).apply((Applicative)instance, ChunkedChunkGenerator::new));

    public ChunkedChunkGenerator(BiomeSource biomeSource, Holder<NoiseGeneratorSettings> settings) {
        super(biomeSource, settings);
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    public ChunkAccess m_224284_(Blender p_224285_, StructureManager p_224286_, RandomState p_224287_, ChunkAccess chunk, int p_224289_, int p_224290_) {
        ChunkPos chunkPos = chunk.m_7697_();
        int chunkMinX = chunkPos.m_45604_();
        int chunkMinZ = chunkPos.m_45605_();
        int minY = chunk.m_141937_();
        int maxY = chunk.m_151558_();
        RandomSource random = RandomSource.m_216335_((long)((long)chunkMinX * 341873128712L + (long)chunkMinZ * 132897987541L));
        double scale = 0.015;
        double threshold = 0.25;
        int octaves = 4;
        double persistence = 0.5;
        SimplexNoise noise = new SimplexNoise(random);
        for (int localX = 0; localX < 16; ++localX) {
            for (int localZ = 0; localZ < 16; ++localZ) {
                for (int worldY = minY; worldY < maxY; ++worldY) {
                    int worldX = chunkMinX + localX;
                    int worldZ = chunkMinZ + localZ;
                    double totalNoise = 0.0;
                    double amplitude = 1.0;
                    double frequency = scale;
                    double maxValue = 0.0;
                    for (int i = 0; i < octaves; ++i) {
                        double n = noise.m_75467_((double)worldX * frequency, (double)worldY * frequency, (double)worldZ * frequency);
                        totalNoise += n * amplitude;
                        maxValue += amplitude;
                        amplitude *= persistence;
                        frequency *= 2.0;
                    }
                    BlockState state = (totalNoise /= maxValue) > threshold ? Blocks.f_50069_.m_49966_() : Blocks.f_50016_.m_49966_();
                    int sectionIndex = chunk.m_151564_(worldY);
                    LevelChunkSection section = chunk.m_183278_(sectionIndex);
                    if (section == null) continue;
                    int xInSection = localX & 0xF;
                    int yInSection = worldY & 0xF;
                    int zInSection = localZ & 0xF;
                    section.m_62991_(xInSection, yInSection, zInSection, state, false);
                }
            }
        }
        return chunk;
    }
}

