/*
 * Decompiled with CFR 0.152.
 */
package yaboichips.cwt.common;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;

public class HelixChunkGenerator
extends NoiseBasedChunkGenerator {
    public static final Codec<HelixChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(g -> g.f_62137_), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(g -> g.f_64318_)).apply((Applicative)instance, HelixChunkGenerator::new));

    public HelixChunkGenerator(BiomeSource biomeSource, Holder<NoiseGeneratorSettings> settings) {
        super(biomeSource, settings);
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    public ChunkAccess m_224284_(Blender p_224285_, StructureManager p_224286_, RandomState p_224287_, ChunkAccess chunk, int p_224289_, int p_224290_) {
        ChunkPos chunkPos = chunk.m_7697_();
        int chunkMinX = chunkPos.m_45604_();
        int chunkMinZ = chunkPos.m_45605_();
        int minY = chunk.m_141937_();
        int maxY = chunk.m_151558_();
        double strandRadius = 6.5;
        double waveAmplitude = 45.0;
        double frequency = 0.035;
        double spacing = 80.0;
        int strands = 8;
        double TWO_PI = Math.PI * 2;
        for (int localX = 0; localX < 16; ++localX) {
            for (int localZ = 0; localZ < 16; ++localZ) {
                int worldX = chunkMinX + localX;
                int worldZ = chunkMinZ + localZ;
                for (int worldY = minY; worldY < maxY; ++worldY) {
                    int sectionIndex;
                    LevelChunkSection section;
                    double distB;
                    double dzB;
                    double dxB;
                    double distA;
                    double dzA;
                    double dxA;
                    double helixBZ;
                    double helixBX;
                    double helixAZ;
                    double helixAX;
                    double centerZ;
                    double centerX;
                    double angleOffset;
                    int i;
                    BlockState finalState = Blocks.f_50016_.m_49966_();
                    boolean nearHelix = false;
                    for (i = 0; i < strands; ++i) {
                        angleOffset = TWO_PI / (double)strands * (double)i;
                        centerX = Math.sin(angleOffset) * spacing;
                        centerZ = Math.cos(angleOffset) * spacing;
                        helixAX = centerX + Math.sin((double)worldY * frequency + angleOffset) * waveAmplitude;
                        helixAZ = centerZ + Math.cos((double)worldY * frequency + angleOffset) * waveAmplitude;
                        helixBX = centerX + Math.sin((double)worldY * frequency + angleOffset + Math.PI) * waveAmplitude;
                        helixBZ = centerZ + Math.cos((double)worldY * frequency + angleOffset + Math.PI) * waveAmplitude;
                        dxA = (double)worldX - helixAX;
                        dzA = (double)worldZ - helixAZ;
                        distA = Math.sqrt(dxA * dxA + dzA * dzA);
                        dxB = (double)worldX - helixBX;
                        dzB = (double)worldZ - helixBZ;
                        distB = Math.sqrt(dxB * dxB + dzB * dzB);
                        if (distA < strandRadius) {
                            finalState = Blocks.f_50069_.m_49966_();
                            nearHelix = true;
                            break;
                        }
                        if (!(distB < strandRadius)) continue;
                        finalState = Blocks.f_50069_.m_49966_();
                        nearHelix = true;
                        break;
                    }
                    if (!nearHelix) {
                        for (i = 0; i < strands; ++i) {
                            angleOffset = TWO_PI / (double)strands * (double)i;
                            double centerY = Math.sin(angleOffset) * spacing;
                            centerZ = Math.cos(angleOffset) * spacing;
                            double helixAY = centerY + Math.sin((double)worldX * frequency + angleOffset) * waveAmplitude;
                            helixAZ = centerZ + Math.cos((double)worldX * frequency + angleOffset) * waveAmplitude;
                            double helixBY = centerY + Math.sin((double)worldX * frequency + angleOffset + Math.PI) * waveAmplitude;
                            helixBZ = centerZ + Math.cos((double)worldX * frequency + angleOffset + Math.PI) * waveAmplitude;
                            double dyA = (double)worldY - helixAY;
                            dzA = (double)worldZ - helixAZ;
                            distA = Math.sqrt(dyA * dyA + dzA * dzA);
                            double dyB = (double)worldY - helixBY;
                            dzB = (double)worldZ - helixBZ;
                            distB = Math.sqrt(dyB * dyB + dzB * dzB);
                            if (distA < strandRadius) {
                                finalState = Blocks.f_50069_.m_49966_();
                                nearHelix = true;
                                break;
                            }
                            if (!(distB < strandRadius)) continue;
                            finalState = Blocks.f_50069_.m_49966_();
                            nearHelix = true;
                            break;
                        }
                    }
                    if (!nearHelix) {
                        for (i = 0; i < strands; ++i) {
                            angleOffset = TWO_PI / (double)strands * (double)i;
                            centerX = Math.sin(angleOffset) * spacing;
                            double centerY = Math.cos(angleOffset) * spacing;
                            helixAX = centerX + Math.sin((double)worldZ * frequency + angleOffset) * waveAmplitude;
                            double helixAY = centerY + Math.cos((double)worldZ * frequency + angleOffset) * waveAmplitude;
                            helixBX = centerX + Math.sin((double)worldZ * frequency + angleOffset + Math.PI) * waveAmplitude;
                            double helixBY = centerY + Math.cos((double)worldZ * frequency + angleOffset + Math.PI) * waveAmplitude;
                            dxA = (double)worldX - helixAX;
                            double dyA = (double)worldY - helixAY;
                            distA = Math.sqrt(dxA * dxA + dyA * dyA);
                            dxB = (double)worldX - helixBX;
                            double dyB = (double)worldY - helixBY;
                            distB = Math.sqrt(dxB * dxB + dyB * dyB);
                            if (distA < strandRadius) {
                                finalState = Blocks.f_50069_.m_49966_();
                                nearHelix = true;
                                break;
                            }
                            if (!(distB < strandRadius)) continue;
                            finalState = Blocks.f_50069_.m_49966_();
                            nearHelix = true;
                            break;
                        }
                    }
                    if (!nearHelix || (section = chunk.m_183278_(sectionIndex = chunk.m_151564_(worldY))) == null) continue;
                    int xInSection = localX & 0xF;
                    int yInSection = worldY & 0xF;
                    int zInSection = localZ & 0xF;
                    section.m_62991_(xInSection, yInSection, zInSection, finalState, false);
                }
            }
        }
        return chunk;
    }
}

