/*
 * Decompiled with CFR 0.152.
 */
package yaboichips.cwt.common;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;

public class WaveChunkGenerator
extends NoiseBasedChunkGenerator {
    public static final Codec<WaveChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(g -> g.f_62137_), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(g -> g.f_64318_)).apply((Applicative)instance, WaveChunkGenerator::new));

    public WaveChunkGenerator(BiomeSource biomeSource, Holder<NoiseGeneratorSettings> settings) {
        super(biomeSource, settings);
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    public ChunkAccess m_224284_(Blender p_224285_, StructureManager p_224286_, RandomState p_224287_, ChunkAccess chunk, int p_224289_, int p_224290_) {
        ChunkPos chunkpos = chunk.m_7697_();
        int chunkMinX = chunkpos.m_45604_();
        int chunkMinZ = chunkpos.m_45605_();
        Heightmap oceanFloor = chunk.m_6005_(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap worldSurface = chunk.m_6005_(Heightmap.Types.WORLD_SURFACE_WG);
        double baseHeight = 64.0;
        double amplitude = 20.0;
        double frequency = 0.05;
        double twistSpeed = 0.15;
        int dirtDepth = 3;
        for (int localX = 0; localX < 16; ++localX) {
            for (int localZ = 0; localZ < 16; ++localZ) {
                int worldX = chunkMinX + localX;
                int worldZ = chunkMinZ + localZ;
                double dist = Math.sqrt(worldX * worldX + worldZ * worldZ);
                double angle = dist * twistSpeed;
                double heightValue = baseHeight + amplitude * Math.sin(angle + (double)(worldX + worldZ) * frequency);
                int surfaceY = (int)Math.floor(heightValue);
                for (int y = 0; y <= surfaceY; ++y) {
                    BlockState state = Blocks.f_50069_.m_49966_();
                    int sectionIndex = chunk.m_151564_(y);
                    LevelChunkSection section = chunk.m_183278_(sectionIndex);
                    if (section == null) continue;
                    int xInSection = localX & 0xF;
                    int yInSection = y & 0xF;
                    int zInSection = localZ & 0xF;
                    section.m_62991_(xInSection, yInSection, zInSection, state, false);
                    oceanFloor.m_64249_(xInSection, y, zInSection, state);
                    worldSurface.m_64249_(xInSection, y, zInSection, state);
                }
            }
        }
        return chunk;
    }
}

