/*
 * Decompiled with CFR 0.152.
 */
package blueprintsplus.client;

import blueprintsplus.client.ClientActions;
import blueprintsplus.client.input.KeyBinds;
import blueprintsplus.client.network.ServerListCache;
import blueprintsplus.client.preview.PlacementController;
import blueprintsplus.client.render.GhostRenderer;
import blueprintsplus.client.ui.HudOverlay;
import blueprintsplus.client.ui.RemoveConfirmScreen;
import blueprintsplus.network.OpenRemoveConfirmPayload;
import blueprintsplus.network.ServerDataPayload;
import blueprintsplus.network.ServerListPayload;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class BlueprintsPlusClient
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"blueprintsplus-client");

    public void onInitializeClient() {
        LOGGER.info("Blueprints+ client initializing");
        KeyBinds.register();
        PlacementController.init();
        GhostRenderer.init();
        HudOverlay.init();
        ClientPlayNetworking.registerGlobalReceiver(ServerListPayload.ID, (payload, context) -> ServerListCache.setNames(payload.names()));
        ClientPlayNetworking.registerGlobalReceiver(ServerDataPayload.ID, (payload, context) -> context.client().execute(() -> {
            ClientActions.openPreviewFromStream(payload.posLongs(), payload.stateIds());
            if (context.client().field_1755 != null) {
                context.client().method_1507(null);
            }
        }));
        ClientPlayNetworking.registerGlobalReceiver(OpenRemoveConfirmPayload.ID, (payload, context) -> {
            int count = payload.count();
            context.client().execute(() -> context.client().method_1507((class_437)new RemoveConfirmScreen(count)));
        });
    }
}

