/*
 * Decompiled with CFR 0.152.
 */
package blueprintsplus.client;

import blueprintsplus.client.BlueprintsPlusClient;
import blueprintsplus.client.preview.BlueprintLoader;
import blueprintsplus.client.preview.PreviewState;
import blueprintsplus.client.preview.RelBlock;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

@Environment(value=EnvType.CLIENT)
public final class ClientActions {
    private ClientActions() {
    }

    public static void openPreviewFromFile(String file) {
        List<RelBlock> bp = BlueprintLoader.load(file);
        if (bp == null || bp.isEmpty()) {
            BlueprintsPlusClient.LOGGER.warn("[Blueprints+] Preview open failed or empty file: {}", (Object)file);
            return;
        }
        PreviewState.get().activate(bp);
        BlueprintsPlusClient.LOGGER.info("[Blueprints+] Preview opened from '{}', blocks={} ", (Object)file, (Object)bp.size());
    }

    public static void openPreviewFromStream(long[] posLongs, int[] stateIds) {
        if (posLongs == null || stateIds == null) {
            return;
        }
        int n = Math.min(posLongs.length, stateIds.length);
        ArrayList<RelBlock> out = new ArrayList<RelBlock>(n);
        for (int i = 0; i < n; ++i) {
            class_2338 rel = class_2338.method_10092((long)posLongs[i]);
            class_2680 state = (class_2680)class_2248.field_10651.method_10200(stateIds[i]);
            if (state == null || state.method_26215()) continue;
            out.add(new RelBlock(rel, state));
        }
        if (out.isEmpty()) {
            BlueprintsPlusClient.LOGGER.warn("[Blueprints+] Streamed preview is empty");
            return;
        }
        PreviewState.get().activate(out);
        BlueprintsPlusClient.LOGGER.info("[Blueprints+] Preview opened from streamed data, blocks={}", (Object)out.size());
    }
}

