/*
 * Decompiled with CFR 0.152.
 */
package blueprintsplus.client.network;

import blueprintsplus.client.BlueprintsPlusClient;
import blueprintsplus.client.preview.MirrorAxis;
import blueprintsplus.client.preview.PreviewState;
import blueprintsplus.client.preview.RelBlock;
import blueprintsplus.client.preview.RotationY;
import blueprintsplus.client.preview.StateTransforms;
import blueprintsplus.network.PlaceBlueprintPayload;
import blueprintsplus.network.RequestServerDataPayload;
import blueprintsplus.network.RequestServerDeletePayload;
import blueprintsplus.network.RequestServerListPayload;
import blueprintsplus.network.RequestServerRemoveConfirmPayload;
import blueprintsplus.network.RequestServerRenamePayload;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public final class ClientSender {
    private ClientSender() {
    }

    public static void sendPlaceFromPreview(class_310 client) {
        int i;
        PreviewState state = PreviewState.get();
        if (!state.isActive()) {
            return;
        }
        if (client.field_1724 == null) {
            return;
        }
        List<RelBlock> bp = state.getBlueprint();
        if (bp == null || bp.isEmpty()) {
            return;
        }
        ArrayList<Long> posList = new ArrayList<Long>();
        ArrayList<Integer> idList = new ArrayList<Integer>();
        int MAX = 8000;
        MirrorAxis mirror = state.getMirror();
        RotationY rotation = state.getRotation();
        for (RelBlock rb : bp) {
            class_2680 bs = rb.state();
            if (bs == null || bs.method_26215()) continue;
            bs = StateTransforms.apply(bs, mirror, rotation);
            class_2338 worldPos = state.toWorld(rb.relPos());
            if (worldPos.method_10264() < client.field_1687.method_31607() || worldPos.method_10264() >= client.field_1687.method_31600()) continue;
            posList.add(worldPos.method_10063());
            idList.add(class_2248.field_10651.method_10206((Object)bs));
            if (posList.size() < 8000) continue;
            break;
        }
        if (posList.isEmpty()) {
            return;
        }
        long[] posArr = new long[posList.size()];
        int[] idArr = new int[idList.size()];
        for (i = 0; i < posList.size(); ++i) {
            posArr[i] = (Long)posList.get(i);
        }
        for (i = 0; i < idList.size(); ++i) {
            idArr[i] = (Integer)idList.get(i);
        }
        PlaceBlueprintPayload payload = new PlaceBlueprintPayload(posArr, idArr);
        ClientPlayNetworking.send((class_8710)payload);
        BlueprintsPlusClient.LOGGER.info("[Blueprints+] Sent placement request: {} blocks", (Object)payload.count());
    }

    public static void requestServerList() {
        ClientPlayNetworking.send((class_8710)new RequestServerListPayload());
        BlueprintsPlusClient.LOGGER.debug("[Blueprints+] Requested server blueprint list");
    }

    public static void requestServerData(String name) {
        if (name == null || name.isEmpty()) {
            return;
        }
        ClientPlayNetworking.send((class_8710)new RequestServerDataPayload(name));
        BlueprintsPlusClient.LOGGER.debug("[Blueprints+] Requested server blueprint data: {}", (Object)name);
    }

    public static void requestServerDelete(String name) {
        if (name == null || name.isEmpty()) {
            return;
        }
        ClientPlayNetworking.send((class_8710)new RequestServerDeletePayload(name));
        BlueprintsPlusClient.LOGGER.debug("[Blueprints+] Requested server delete: {}", (Object)name);
    }

    public static void requestServerRemoveConfirm() {
        ClientPlayNetworking.send((class_8710)new RequestServerRemoveConfirmPayload());
        BlueprintsPlusClient.LOGGER.debug("[Blueprints+] Confirmed server remove request");
    }

    public static void requestServerRename(String oldName, String newName) {
        if (oldName == null || oldName.isEmpty() || newName == null || newName.isEmpty()) {
            return;
        }
        ClientPlayNetworking.send((class_8710)new RequestServerRenamePayload(oldName, newName));
        BlueprintsPlusClient.LOGGER.debug("[Blueprints+] Requested server rename: {} -> {}", (Object)oldName, (Object)newName);
    }
}

