/*
 * Decompiled with CFR 0.152.
 */
package blueprintsplus.client.preview;

import blueprintsplus.client.BlueprintsPlusClient;
import blueprintsplus.client.preview.RelBlock;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2680;

@Environment(value=EnvType.CLIENT)
public final class BlueprintLoader {
    private BlueprintLoader() {
    }

    public static List<RelBlock> load(String file) {
        try {
            if (file == null || file.isEmpty()) {
                return List.of();
            }
            Path dir = FabricLoader.getInstance().getGameDir().resolve("blueprints");
            Path path = dir.resolve((String)(file.endsWith(".nbt") ? file : file + ".nbt"));
            if (!Files.exists(path, new LinkOption[0])) {
                BlueprintsPlusClient.LOGGER.warn("[Blueprints+] Blueprint file not found: {}", (Object)path);
                return List.of();
            }
            class_2487 tag = class_2507.method_30613((Path)path, (class_2505)class_2505.method_53898());
            if (tag == null) {
                return List.of();
            }
            long[] posLongs = tag.method_10565("posLongs");
            int[] stateIds = tag.method_10561("stateIds");
            int n = Math.min(posLongs.length, stateIds.length);
            ArrayList<RelBlock> out = new ArrayList<RelBlock>(n);
            for (int i = 0; i < n; ++i) {
                class_2338 rel = class_2338.method_10092((long)posLongs[i]);
                class_2680 state = (class_2680)class_2248.field_10651.method_10200(stateIds[i]);
                if (state == null || state.method_26215()) continue;
                out.add(new RelBlock(rel, state));
            }
            BlueprintsPlusClient.LOGGER.info("[Blueprints+] Loaded blueprint '{}' ({} blocks)", (Object)file, (Object)out.size());
            return out;
        }
        catch (Exception e) {
            BlueprintsPlusClient.LOGGER.error("[Blueprints+] Failed to load blueprint '{}': {}", (Object)file, (Object)e.toString());
            return List.of();
        }
    }
}

