/*
 * Decompiled with CFR 0.152.
 */
package blueprintsplus.client.preview;

import blueprintsplus.client.BlueprintsPlusClient;
import blueprintsplus.client.input.KeyBinds;
import blueprintsplus.client.network.ClientSender;
import blueprintsplus.client.preview.BlueprintLoader;
import blueprintsplus.client.preview.PreviewState;
import blueprintsplus.client.preview.RelBlock;
import blueprintsplus.client.preview.TestBlueprints;
import blueprintsplus.client.ui.BlueprintBrowserScreen;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_746;
import org.lwjgl.glfw.GLFW;

@Environment(value=EnvType.CLIENT)
public final class PlacementController {
    private PlacementController() {
    }

    public static void init() {
        ClientTickEvents.END_CLIENT_TICK.register(PlacementController::onEndTick);
    }

    private static void onEndTick(class_310 client) {
        if (client.field_1724 == null) {
            return;
        }
        PlacementController.handleKeys(client);
        PlacementController.updateCrosshairAnchor(client);
    }

    private static void handleKeys(class_310 client) {
        class_746 player = client.field_1724;
        if (player == null) {
            return;
        }
        if (!player.method_31549().field_7477) {
            return;
        }
        PreviewState state = PreviewState.get();
        if (KeyBinds.OPEN_BROWSER.method_1436() && client.field_1755 == null) {
            client.method_1507((class_437)new BlueprintBrowserScreen());
        }
        if (KeyBinds.TOGGLE_GHOST.method_1436()) {
            if (state.isActive()) {
                state.deactivate();
                BlueprintsPlusClient.LOGGER.info("[Blueprints+] Preview deactivated");
            } else {
                List<RelBlock> fileBp = BlueprintLoader.load("my_build_coordinates");
                if (fileBp == null || fileBp.isEmpty()) {
                    state.activate(TestBlueprints.smallPad());
                    BlueprintsPlusClient.LOGGER.info("[Blueprints+] Preview activated (smallPad)");
                } else {
                    state.activate(fileBp);
                    BlueprintsPlusClient.LOGGER.info("[Blueprints+] Preview activated (file: my_build_coordinates)");
                }
                PlacementController.anchorToCrosshair(client, state);
            }
        }
        if (!state.isActive()) {
            return;
        }
        if (KeyBinds.ROTATE.method_1436()) {
            if (PlacementController.isShiftDown(client)) {
                state.rotateCcw();
                BlueprintsPlusClient.LOGGER.debug("[Blueprints+] Rotate CCW");
            } else {
                state.rotateCw();
                BlueprintsPlusClient.LOGGER.debug("[Blueprints+] Rotate CW");
            }
        }
        if (KeyBinds.TOGGLE_MIRROR.method_1436()) {
            state.cycleMirror();
            BlueprintsPlusClient.LOGGER.debug("[Blueprints+] Mirror cycle -> {}", (Object)state.getMirror());
        }
        if (KeyBinds.TOGGLE_RENDER_MODE.method_1436()) {
            state.toggleRenderMode();
            BlueprintsPlusClient.LOGGER.info("[Blueprints+] Render mode: {}", (Object)(state.isRenderBlocks() ? "Blocks" : "Outlines"));
        }
        if (KeyBinds.NUDGE_LEFT.method_1436()) {
            state.nudge(-1, 0, 0);
        }
        if (KeyBinds.NUDGE_RIGHT.method_1436()) {
            state.nudge(1, 0, 0);
        }
        if (KeyBinds.NUDGE_FORWARD.method_1436()) {
            state.nudge(0, 0, -1);
        }
        if (KeyBinds.NUDGE_BACK.method_1436()) {
            state.nudge(0, 0, 1);
        }
        if (KeyBinds.NUDGE_UP.method_1436()) {
            state.nudge(0, 1, 0);
        }
        if (KeyBinds.NUDGE_DOWN.method_1436()) {
            state.nudge(0, -1, 0);
        }
        if (KeyBinds.CONFIRM.method_1436()) {
            ClientSender.sendPlaceFromPreview(client);
            BlueprintsPlusClient.LOGGER.info("[Blueprints+] Confirm pressed \u2192 sent place request");
            state.deactivate();
        }
        if (KeyBinds.CANCEL.method_1436()) {
            state.deactivate();
            BlueprintsPlusClient.LOGGER.info("[Blueprints+] Preview canceled");
        }
    }

    private static void updateCrosshairAnchor(class_310 client) {
        PreviewState state = PreviewState.get();
        if (!state.isActive()) {
            return;
        }
        class_239 hit = client.field_1765;
        if (hit == null) {
            return;
        }
        state.setLastHit(hit);
        if (hit.method_17783() == class_239.class_240.field_1332) {
            class_3965 bhr = (class_3965)hit;
            class_2350 face = bhr.method_17780();
            class_2338 base = bhr.method_17777().method_10093(face);
            state.setAnchorPos(base);
            state.setFacing(face);
        }
    }

    private static void anchorToCrosshair(class_310 client, PreviewState state) {
        class_239 hit = client.field_1765;
        if (hit != null && hit.method_17783() == class_239.class_240.field_1332) {
            class_3965 bhr = (class_3965)hit;
            class_2350 face = bhr.method_17780();
            state.setAnchorPos(bhr.method_17777().method_10093(face));
            state.setFacing(face);
        } else if (client.field_1724 != null) {
            class_2338 pos = client.field_1724.method_24515();
            state.setAnchorPos(pos);
            state.setFacing(class_2350.field_11036);
        }
    }

    private static boolean isShiftDown(class_310 client) {
        long handle = client.method_22683().method_4490();
        return GLFW.glfwGetKey((long)handle, (int)340) == 1 || GLFW.glfwGetKey((long)handle, (int)344) == 1;
    }
}

