/*
 * Decompiled with CFR 0.152.
 */
package blueprintsplus.client.preview;

import blueprintsplus.client.preview.MirrorAxis;
import blueprintsplus.client.preview.RelBlock;
import blueprintsplus.client.preview.RotationY;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;

@Environment(value=EnvType.CLIENT)
public final class PreviewState {
    private static final PreviewState INSTANCE = new PreviewState();
    private boolean active;
    private class_2338 anchorPos = class_2338.field_10980;
    private class_2350 facing = class_2350.field_11036;
    private RotationY rotation = RotationY.R0;
    private MirrorAxis mirror = MirrorAxis.NONE;
    private class_2338 offset = class_2338.field_10980;
    private List<RelBlock> blueprint = Collections.emptyList();
    private class_239 lastHit;
    private boolean renderBlocks = true;

    private PreviewState() {
    }

    public static PreviewState get() {
        return INSTANCE;
    }

    public void activate(List<RelBlock> blueprint) {
        this.blueprint = blueprint != null ? blueprint : Collections.emptyList();
        this.active = true;
        this.rotation = RotationY.R0;
        this.mirror = MirrorAxis.NONE;
        this.offset = class_2338.field_10980;
    }

    public void deactivate() {
        this.active = false;
        this.blueprint = Collections.emptyList();
    }

    public boolean isActive() {
        return this.active;
    }

    public class_2338 getAnchorPos() {
        return this.anchorPos;
    }

    public void setAnchorPos(class_2338 pos) {
        this.anchorPos = pos;
    }

    public class_2350 getFacing() {
        return this.facing;
    }

    public void setFacing(class_2350 dir) {
        this.facing = dir;
    }

    public RotationY getRotation() {
        return this.rotation;
    }

    public void rotateCw() {
        this.rotation = this.rotation.rotateCw();
    }

    public void rotateCcw() {
        this.rotation = this.rotation.rotateCcw();
    }

    public MirrorAxis getMirror() {
        return this.mirror;
    }

    public void cycleMirror() {
        this.mirror = this.mirror.next();
    }

    public class_2338 getOffset() {
        return this.offset;
    }

    public void nudge(int dx, int dy, int dz) {
        this.offset = this.offset.method_10069(dx, dy, dz);
    }

    public List<RelBlock> getBlueprint() {
        return this.blueprint;
    }

    public class_239 getLastHit() {
        return this.lastHit;
    }

    public void setLastHit(class_239 hit) {
        this.lastHit = hit;
    }

    public class_2338 toWorld(class_2338 relative) {
        class_2338 mirrored = this.mirror.apply(relative);
        class_2338 rotated = this.rotation.apply(mirrored);
        return this.anchorPos.method_10081((class_2382)this.offset).method_10081((class_2382)rotated);
    }

    public boolean isRenderBlocks() {
        return this.renderBlocks;
    }

    public void toggleRenderMode() {
        this.renderBlocks = !this.renderBlocks;
    }
}

