/*
 * Decompiled with CFR 0.152.
 */
package blueprintsplus.client.preview;

import blueprintsplus.client.preview.MirrorAxis;
import blueprintsplus.client.preview.RotationY;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2750;
import net.minecraft.class_2769;

@Environment(value=EnvType.CLIENT)
public final class StateTransforms {
    private StateTransforms() {
    }

    public static class_2680 apply(class_2680 in, MirrorAxis mirror, RotationY rot) {
        if (in == null) {
            return null;
        }
        class_2680 s = in;
        s = StateTransforms.rotateGeneric(s, rot);
        s = StateTransforms.mirrorGeneric(s, mirror);
        s = StateTransforms.mirrorXZSpecials(s, mirror);
        return s;
    }

    public static class_2680 rotateY(class_2680 state, RotationY rot) {
        if (state == null || rot == null || rot == RotationY.R0) {
            return state;
        }
        return StateTransforms.rotateGeneric(state, rot);
    }

    public static class_2680 mirrorXZ(class_2680 state, MirrorAxis axis) {
        if (state == null || axis == null || axis == MirrorAxis.NONE) {
            return state;
        }
        class_2680 s = StateTransforms.mirrorGeneric(state, axis);
        s = StateTransforms.mirrorXZSpecials(s, axis);
        return s;
    }

    private static class_2680 rotateGeneric(class_2680 state, RotationY rot) {
        if (rot == null || rot == RotationY.R0) {
            return state;
        }
        class_2680 s = state;
        for (class_2769 prop : state.method_28501()) {
            if (prop == class_2741.field_12481) {
                class_2350 d = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
                s = (class_2680)s.method_11657((class_2769)class_2741.field_12481, (Comparable)StateTransforms.rotateDirY(d, rot));
                continue;
            }
            if (prop == class_2741.field_12525) {
                class_2350 d = (class_2350)state.method_11654((class_2769)class_2741.field_12525);
                s = (class_2680)s.method_11657((class_2769)class_2741.field_12525, (Comparable)StateTransforms.rotateDirY(d, rot));
                continue;
            }
            if (prop == class_2741.field_12496) {
                class_2350.class_2351 ax = (class_2350.class_2351)state.method_11654((class_2769)class_2741.field_12496);
                s = (class_2680)s.method_11657((class_2769)class_2741.field_12496, (Comparable)StateTransforms.rotateAxisY(ax, rot));
                continue;
            }
            if (prop == class_2741.field_12529) {
                class_2350.class_2351 ax = (class_2350.class_2351)state.method_11654((class_2769)class_2741.field_12529);
                s = (class_2680)s.method_11657((class_2769)class_2741.field_12529, (Comparable)StateTransforms.rotateAxisY(ax, rot));
                continue;
            }
            if (prop != class_2741.field_12532) continue;
            int r = (Integer)state.method_11654((class_2769)class_2741.field_12532);
            int steps = 0;
            switch (rot) {
                case R90: {
                    steps = 4;
                    break;
                }
                case R180: {
                    steps = 8;
                    break;
                }
                case R270: {
                    steps = 12;
                }
            }
            s = (class_2680)s.method_11657((class_2769)class_2741.field_12532, (Comparable)Integer.valueOf(r + steps & 0xF));
        }
        s = StateTransforms.rotateDirectionalSides(s, rot);
        return s;
    }

    private static class_2680 mirrorGeneric(class_2680 state, MirrorAxis axis) {
        if (axis == null || axis == MirrorAxis.NONE) {
            return state;
        }
        class_2680 s = state;
        for (class_2769 prop : state.method_28501()) {
            class_2350 d;
            if (prop == class_2741.field_12481) {
                d = (class_2350)s.method_11654((class_2769)class_2741.field_12481);
                s = (class_2680)s.method_11657((class_2769)class_2741.field_12481, (Comparable)StateTransforms.mirrorDir(d, axis));
                continue;
            }
            if (prop != class_2741.field_12525) continue;
            d = (class_2350)s.method_11654((class_2769)class_2741.field_12525);
            s = (class_2680)s.method_11657((class_2769)class_2741.field_12525, (Comparable)StateTransforms.mirrorDir(d, axis));
        }
        s = StateTransforms.mirrorDirectionalSides(s, axis);
        return s;
    }

    private static class_2680 mirrorXZSpecials(class_2680 state, MirrorAxis axis) {
        if (axis == null || axis == MirrorAxis.NONE) {
            return state;
        }
        class_2680 s = state;
        if (s.method_28501().contains(class_2741.field_12520)) {
            class_2750 hinge = (class_2750)s.method_11654((class_2769)class_2741.field_12520);
            s = (class_2680)s.method_11657((class_2769)class_2741.field_12520, (Comparable)(hinge == class_2750.field_12588 ? class_2750.field_12586 : class_2750.field_12588));
        }
        return s;
    }

    private static class_2350 rotateDirY(class_2350 d, RotationY rot) {
        if (d.method_10166() == class_2350.class_2351.field_11052) {
            return d;
        }
        switch (rot) {
            case R90: {
                return d.method_10170();
            }
            case R180: {
                return d.method_10153();
            }
            case R270: {
                return d.method_10160();
            }
        }
        return d;
    }

    private static class_2350.class_2351 rotateAxisY(class_2350.class_2351 ax, RotationY rot) {
        if (ax == class_2350.class_2351.field_11052) {
            return ax;
        }
        switch (rot) {
            case R90: 
            case R270: {
                return ax == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
            }
        }
        return ax;
    }

    private static class_2350 mirrorDir(class_2350 d, MirrorAxis axis) {
        if (d.method_10166() == class_2350.class_2351.field_11052) {
            return d;
        }
        if (axis == MirrorAxis.X) {
            if (d == class_2350.field_11034) {
                return class_2350.field_11039;
            }
            if (d == class_2350.field_11039) {
                return class_2350.field_11034;
            }
            return d;
        }
        if (d == class_2350.field_11043) {
            return class_2350.field_11035;
        }
        if (d == class_2350.field_11035) {
            return class_2350.field_11043;
        }
        return d;
    }

    private static class_2680 rotateDirectionalSides(class_2680 state, RotationY rot) {
        if (rot == null || rot == RotationY.R0) {
            return state;
        }
        class_2680 s = state;
        Object north = StateTransforms.getDirPropValue(s, "north");
        Object east = StateTransforms.getDirPropValue(s, "east");
        Object south = StateTransforms.getDirPropValue(s, "south");
        Object west = StateTransforms.getDirPropValue(s, "west");
        if (north == null && east == null && south == null && west == null) {
            return s;
        }
        int steps = rot == RotationY.R90 ? 1 : (rot == RotationY.R180 ? 2 : 3);
        Object[] vals = new Object[]{north, east, south, west};
        Object[] out = new Object[4];
        for (int i = 0; i < 4; ++i) {
            out[i + steps & 3] = vals[i];
        }
        s = StateTransforms.setDirPropValue(s, "north", out[0]);
        s = StateTransforms.setDirPropValue(s, "east", out[1]);
        s = StateTransforms.setDirPropValue(s, "south", out[2]);
        s = StateTransforms.setDirPropValue(s, "west", out[3]);
        return s;
    }

    private static class_2680 mirrorDirectionalSides(class_2680 state, MirrorAxis axis) {
        if (axis == null || axis == MirrorAxis.NONE) {
            return state;
        }
        class_2680 s = state;
        Object north = StateTransforms.getDirPropValue(s, "north");
        Object east = StateTransforms.getDirPropValue(s, "east");
        Object south = StateTransforms.getDirPropValue(s, "south");
        Object west = StateTransforms.getDirPropValue(s, "west");
        if (north == null && east == null && south == null && west == null) {
            return s;
        }
        if (axis == MirrorAxis.X) {
            s = StateTransforms.setDirPropValue(s, "north", north);
            s = StateTransforms.setDirPropValue(s, "south", south);
            s = StateTransforms.setDirPropValue(s, "east", west);
            s = StateTransforms.setDirPropValue(s, "west", east);
        } else {
            s = StateTransforms.setDirPropValue(s, "north", south);
            s = StateTransforms.setDirPropValue(s, "south", north);
            s = StateTransforms.setDirPropValue(s, "east", east);
            s = StateTransforms.setDirPropValue(s, "west", west);
        }
        return s;
    }

    private static Object getDirPropValue(class_2680 s, String name) {
        for (class_2769 p : s.method_28501()) {
            if (!p.method_11899().equals(name)) continue;
            return s.method_11654(p);
        }
        return null;
    }

    private static class_2680 setDirPropValue(class_2680 s, String name, Object val) {
        if (val == null) {
            return s;
        }
        for (class_2769 p : s.method_28501()) {
            if (!p.method_11899().equals(name)) continue;
            try {
                class_2769 cast = p;
                if (!cast.method_11898().contains(val)) {
                    for (Object allowed : cast.method_11898()) {
                        if (!allowed.toString().equalsIgnoreCase(val.toString())) continue;
                        val = allowed;
                        break;
                    }
                    if (!cast.method_11898().contains(val)) {
                        return s;
                    }
                }
                return (class_2680)s.method_11657(cast, (Comparable)val);
            }
            catch (Throwable ignored) {
                return s;
            }
        }
        return s;
    }
}

