/*
 * Decompiled with CFR 0.152.
 */
package blueprintsplus.client.render;

import blueprintsplus.client.preview.MirrorAxis;
import blueprintsplus.client.preview.PreviewState;
import blueprintsplus.client.preview.RelBlock;
import blueprintsplus.client.preview.RotationY;
import blueprintsplus.client.preview.StateTransforms;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_761;
import net.minecraft.class_776;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public final class GhostRenderer {
    private static final Logger LOG = LoggerFactory.getLogger((String)"blueprintsplus-ghost-renderer");

    private GhostRenderer() {
    }

    public static void init() {
        WorldRenderEvents.AFTER_TRANSLUCENT.register(context -> {
            PreviewState state = PreviewState.get();
            if (!state.isActive()) {
                return;
            }
            class_4587 matrices = context.matrixStack();
            class_4597 consumers = context.consumers();
            class_4184 camera = context.camera();
            if (consumers == null || camera == null) {
                return;
            }
            class_243 camPos = camera.method_19326();
            double camX = camPos.field_1352;
            double camY = camPos.field_1351;
            double camZ = camPos.field_1350;
            double maxDistSq = 16384.0;
            List<RelBlock> blocks = state.getBlueprint();
            if (blocks == null || blocks.isEmpty()) {
                return;
            }
            class_4588 lineConsumer = consumers.getBuffer(class_1921.method_23594());
            class_776 brm = class_310.method_1551().method_1541();
            MirrorAxis mirror = state.getMirror();
            RotationY rotation = state.getRotation();
            boolean renderBlocks = state.isRenderBlocks();
            matrices.method_22903();
            for (RelBlock rb : blocks) {
                double cz;
                double cy;
                class_2338 worldPos = state.toWorld(rb.relPos());
                double cx = (double)worldPos.method_10263() + 0.5 - camX;
                double distSq = cx * cx + (cy = (double)worldPos.method_10264() + 0.5 - camY) * cy + (cz = (double)worldPos.method_10260() + 0.5 - camZ) * cz;
                if (distSq > maxDistSq) continue;
                matrices.method_22903();
                matrices.method_22904((double)worldPos.method_10263() - camX, (double)worldPos.method_10264() - camY, (double)worldPos.method_10260() - camZ);
                if (renderBlocks) {
                    try {
                        class_2680 bs = rb.state();
                        if (bs != null && !bs.method_26215()) {
                            bs = StateTransforms.apply(bs, mirror, rotation);
                            brm.method_3353(bs, matrices, consumers, 0xF000F0, class_4608.field_21444);
                        }
                    }
                    catch (Throwable bs) {
                        // empty catch block
                    }
                }
                matrices.method_22909();
                double minX = (double)worldPos.method_10263() - camX;
                double minY = (double)worldPos.method_10264() - camY;
                double minZ = (double)worldPos.method_10260() - camZ;
                double maxX = minX + 1.0;
                double maxY = minY + 1.0;
                double maxZ = minZ + 1.0;
                try {
                    class_761.method_22980((class_4587)matrices, (class_4588)lineConsumer, (double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.45f);
                }
                catch (Throwable throwable) {}
            }
            matrices.method_22909();
        });
        LOG.info("GhostRenderer initialized");
    }
}

