/*
 * Decompiled with CFR 0.152.
 */
package blueprintsplus.client.ui;

import blueprintsplus.client.ClientActions;
import blueprintsplus.client.network.ClientSender;
import blueprintsplus.client.network.ServerListCache;
import blueprintsplus.client.ui.RenamePromptScreen;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class BlueprintBrowserScreen
extends class_437 {
    private Tab tab = Tab.LOCAL;
    private final List<String> items = new ArrayList<String>();
    private String selected = null;
    private int scrollIndex = 0;
    private static final int ROWS = 9;
    private int panelX;
    private int panelY;
    private int panelW;
    private int panelH;
    private int listX;
    private int listY;
    private int listW;
    private int rowH;

    public BlueprintBrowserScreen() {
        super((class_2561)class_2561.method_43470((String)"Blueprints Browser"));
    }

    protected void method_25426() {
        super.method_25426();
        this.loadTab(Tab.LOCAL);
        this.buildWidgets();
    }

    private void loadTab(Tab newTab) {
        this.tab = newTab;
        this.selected = null;
        this.scrollIndex = 0;
        if (this.tab == Tab.LOCAL) {
            this.items.clear();
            Path dir = FabricLoader.getInstance().getGameDir().resolve("blueprints");
            if (Files.exists(dir, new LinkOption[0])) {
                try (Stream<Path> s = Files.list(dir);){
                    this.items.addAll(s.filter(p -> p.getFileName().toString().toLowerCase().endsWith(".nbt")).map(p -> p.getFileName().toString().replaceFirst("\\.nbt$", "")).sorted(Comparator.naturalOrder()).collect(Collectors.toList()));
                }
                catch (IOException iOException) {}
            }
        } else {
            ClientSender.requestServerList();
            this.items.clear();
            this.items.addAll(ServerListCache.getNames());
        }
    }

    private void refresh() {
        if (this.tab == Tab.LOCAL) {
            this.loadTab(Tab.LOCAL);
        } else {
            ClientSender.requestServerList();
            this.items.clear();
            this.items.addAll(ServerListCache.getNames());
        }
        this.buildWidgets();
    }

    private void buildWidgets() {
        this.method_37067();
        this.panelW = Math.min(420, this.field_22789 - 40);
        this.panelH = Math.min(260, this.field_22790 - 60);
        this.panelX = (this.field_22789 - this.panelW) / 2;
        this.panelY = (this.field_22790 - this.panelH) / 2;
        class_4185 localTab = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Local"), b -> {
            this.loadTab(Tab.LOCAL);
            this.buildWidgets();
        }).method_46434(this.panelX + 10, this.panelY + 22, 70, 18).method_46431();
        class_4185 serverTab = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Server"), b -> {
            this.loadTab(Tab.SERVER);
            this.buildWidgets();
        }).method_46434(this.panelX + 90, this.panelY + 22, 70, 18).method_46431();
        this.method_37063((class_364)localTab);
        this.method_37063((class_364)serverTab);
        this.listX = this.panelX + 10;
        this.listY = this.panelY + 48;
        this.listW = 220;
        this.rowH = 18;
        if (this.selected == null && !this.items.isEmpty()) {
            this.selected = this.items.get(Math.min(this.scrollIndex, this.items.size() - 1));
        }
        int end = Math.min(this.items.size(), this.scrollIndex + 9);
        for (int i = this.scrollIndex; i < end; ++i) {
            String name = this.items.get(i);
            int y = this.listY + (i - this.scrollIndex) * (this.rowH + 2);
            boolean isSel = name.equals(this.selected);
            String label = (isSel ? "> " : "  ") + name + this.localSuffix(name);
            class_4185 row = class_4185.method_46430((class_2561)class_2561.method_43470((String)label), btn -> {
                this.selected = name;
            }).method_46434(this.listX, y, this.listW, this.rowH).method_46431();
            this.method_37063((class_364)row);
        }
        class_4185 up = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u25b2"), b -> {
            if (this.scrollIndex > 0) {
                --this.scrollIndex;
                this.buildWidgets();
            }
        }).method_46434(this.listX + this.listW + 6, this.listY, 20, 18).method_46431();
        class_4185 down = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u25bc"), b -> {
            if (this.scrollIndex + 9 < this.items.size()) {
                ++this.scrollIndex;
                this.buildWidgets();
            }
        }).method_46434(this.listX + this.listW + 6, this.listY + (this.rowH + 2) * 8, 20, 18).method_46431();
        this.method_37063((class_364)up);
        this.method_37063((class_364)down);
        int infoX = this.listX + this.listW + 40;
        int infoY = this.listY;
        String infoTitle = this.selected != null ? this.selected : "(no selection)";
        this.drawStaticTextButton("Name: " + infoTitle, infoX, infoY, 120);
        String countText = this.tab == Tab.LOCAL && this.selected != null ? "Blocks: " + this.localBlockCount(this.selected) : "Blocks: ?";
        this.drawStaticTextButton(countText, infoX, infoY + 24, 120);
        int bottomY = this.panelY + this.panelH - 24;
        class_4185 load = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Load"), b -> this.onLoad()).method_46434(this.panelX + 5, bottomY, 60, 18).method_46431();
        class_4185 refresh = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Refresh"), b -> this.refresh()).method_46434(this.panelX + 80, bottomY, 60, 18).method_46431();
        class_4185 del = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Delete"), b -> this.onDelete()).method_46434(this.panelX + 155, bottomY, 60, 18).method_46431();
        class_4185 rename = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Rename"), b -> this.onRename()).method_46434(this.panelX + 230, bottomY, 60, 18).method_46431();
        class_4185 close = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Close"), b -> this.closeScreen()).method_46434(this.panelX + this.panelW - 70 - 10, bottomY, 70, 18).method_46431();
        this.method_37063((class_364)load);
        this.method_37063((class_364)refresh);
        this.method_37063((class_364)del);
        this.method_37063((class_364)rename);
        this.method_37063((class_364)close);
    }

    private void drawStaticTextButton(String text, int x, int y, int w) {
        class_4185 label = class_4185.method_46430((class_2561)class_2561.method_43470((String)text), b -> {}).method_46434(x, y, w, 18).method_46431();
        label.field_22763 = false;
        this.method_37063((class_364)label);
    }

    private String localSuffix(String name) {
        if (this.tab != Tab.LOCAL) {
            return "";
        }
        int n = this.localBlockCount(name);
        if (n >= 0) {
            return "  (" + n + ")";
        }
        return "";
    }

    private int localBlockCount(String name) {
        try {
            class_2487 tag;
            Path dir = FabricLoader.getInstance().getGameDir().resolve("blueprints");
            Path path = dir.resolve((String)(name.endsWith(".nbt") ? name : name + ".nbt"));
            if (!Files.exists(path, new LinkOption[0])) {
                return -1;
            }
            try {
                tag = class_2507.method_30613((Path)path, (class_2505)class_2505.method_53898());
            }
            catch (Throwable t) {
                tag = class_2507.method_10633((Path)path);
            }
            if (tag == null) {
                return -1;
            }
            long[] pos = tag.method_10565("posLongs");
            int[] ids = tag.method_10561("stateIds");
            return Math.min(pos.length, ids.length);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private void onLoad() {
        if (this.selected == null) {
            return;
        }
        if (this.tab == Tab.LOCAL) {
            ClientActions.openPreviewFromFile(this.selected);
            this.closeScreen();
        } else {
            ClientSender.requestServerData(this.selected);
            this.closeScreen();
        }
    }

    private void onDelete() {
        if (this.selected == null) {
            return;
        }
        if (this.tab == Tab.LOCAL) {
            try {
                Path dir = FabricLoader.getInstance().getGameDir().resolve("blueprints");
                Path path = dir.resolve((String)(this.selected.endsWith(".nbt") ? this.selected : this.selected + ".nbt"));
                if (Files.exists(path, new LinkOption[0])) {
                    Files.delete(path);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.refresh();
        } else {
            ClientSender.requestServerDelete(this.selected);
            this.items.clear();
            this.items.addAll(ServerListCache.getNames());
            this.buildWidgets();
        }
    }

    private void onRename() {
        if (this.selected == null) {
            return;
        }
        String current = this.selected;
        class_310.method_1551().method_1507((class_437)new RenamePromptScreen(current, newName -> {
            if (newName == null || newName.isBlank()) {
                class_310.method_1551().method_1507((class_437)this);
                return;
            }
            if ((newName = this.sanitizeName((String)newName)).equals(current)) {
                class_310.method_1551().method_1507((class_437)this);
                return;
            }
            if (this.tab == Tab.LOCAL) {
                this.renameLocal(current, (String)newName);
                this.loadTab(Tab.LOCAL);
            } else {
                ClientSender.requestServerRename(current, newName);
                this.items.clear();
                this.items.addAll(ServerListCache.getNames());
            }
            this.selected = newName;
            class_310.method_1551().method_1507((class_437)this);
            this.buildWidgets();
        }, () -> class_310.method_1551().method_1507((class_437)this)));
    }

    private void renameLocal(String oldName, String newName) {
        try {
            Path dir = FabricLoader.getInstance().getGameDir().resolve("blueprints");
            Files.createDirectories(dir, new FileAttribute[0]);
            Path src = dir.resolve((String)(oldName.endsWith(".nbt") ? oldName : oldName + ".nbt"));
            Path dst = dir.resolve((String)(newName.endsWith(".nbt") ? newName : newName + ".nbt"));
            if (!Files.exists(src, new LinkOption[0])) {
                return;
            }
            if (Files.exists(dst, new LinkOption[0])) {
                String base = newName;
                int i = 1;
                do {
                    dst = dir.resolve(base + "_" + i + ".nbt");
                    ++i;
                } while (Files.exists(dst, new LinkOption[0]));
            }
            Files.move(src, dst, new CopyOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String sanitizeName(String s) {
        String out = s.trim();
        if ((out = out.replaceAll("[\\/:*?\"<>|]", "_")).toLowerCase().endsWith(".nbt")) {
            out = out.substring(0, out.length() - 4);
        }
        return out;
    }

    private void closeScreen() {
        class_310.method_1551().method_1507(null);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        List<String> latest;
        context.method_25294(0, 0, this.field_22789, this.field_22790, -1442840576);
        int px2 = this.panelX + this.panelW;
        int py2 = this.panelY + this.panelH;
        context.method_25294(this.panelX, this.panelY, px2, py2, -300871407);
        context.method_49601(this.panelX, this.panelY, this.panelW, this.panelH, -1);
        super.method_25394(context, mouseX, mouseY, delta);
        int centerX = this.panelX + this.panelW / 2;
        context.method_27534(this.field_22793, this.method_25440(), centerX, this.panelY + 8, 65535);
        if (this.tab == Tab.SERVER && (latest = ServerListCache.getNames()).size() != this.items.size()) {
            this.items.clear();
            this.items.addAll(latest);
            this.buildWidgets();
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 265: {
                if (this.items.isEmpty()) {
                    return super.method_25404(keyCode, scanCode, modifiers);
                }
                int idx = this.selectedIndex();
                idx = idx > 0 ? --idx : 0;
                this.ensureVisible(idx);
                this.selected = this.items.get(idx);
                this.buildWidgets();
                return true;
            }
            case 264: {
                if (this.items.isEmpty()) {
                    return super.method_25404(keyCode, scanCode, modifiers);
                }
                int idx = this.selectedIndex();
                idx = idx < this.items.size() - 1 ? ++idx : this.items.size() - 1;
                this.ensureVisible(idx);
                this.selected = this.items.get(idx);
                this.buildWidgets();
                return true;
            }
            case 266: {
                if (this.scrollIndex <= 0) break;
                this.scrollIndex = Math.max(0, this.scrollIndex - 9);
                this.buildWidgets();
                return true;
            }
            case 267: {
                int maxStart = Math.max(0, this.items.size() - 9);
                if (this.scrollIndex >= maxStart) break;
                this.scrollIndex = Math.min(maxStart, this.scrollIndex + 9);
                this.buildWidgets();
                return true;
            }
            case 257: 
            case 335: {
                this.onLoad();
                return true;
            }
            case 261: {
                this.onDelete();
                return true;
            }
            case 82: {
                this.refresh();
                return true;
            }
            case 256: {
                this.closeScreen();
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private int selectedIndex() {
        if (this.selected == null) {
            return this.scrollIndex;
        }
        int idx = this.items.indexOf(this.selected);
        return idx >= 0 ? idx : this.scrollIndex;
    }

    private void ensureVisible(int idx) {
        int maxStart;
        if (idx < this.scrollIndex) {
            this.scrollIndex = idx;
        } else if (idx >= this.scrollIndex + 9) {
            this.scrollIndex = idx - 9 + 1;
        }
        if (this.scrollIndex < 0) {
            this.scrollIndex = 0;
        }
        if (this.scrollIndex > (maxStart = Math.max(0, this.items.size() - 9))) {
            this.scrollIndex = maxStart;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static enum Tab {
        LOCAL,
        SERVER;

    }
}

