/*
 * Decompiled with CFR 0.152.
 */
package blueprintsplus.command;

import blueprintsplus.BlueprintsPlus;
import blueprintsplus.network.OpenRemoveConfirmPayload;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_8710;

public final class BpCommands {
    private static final Map<UUID, List<class_2338>> PENDING_REMOVE = new HashMap<UUID, List<class_2338>>();
    private static final Map<UUID, Long> PENDING_REMOVE_EXP = new HashMap<UUID, Long>();

    private BpCommands() {
    }

    private static class_2338 raycastBlock(class_3222 player, double distance) {
        class_239 hr = player.method_5745(distance, 0.0f, false);
        if (hr instanceof class_3965) {
            class_3965 bhr = (class_3965)hr;
            if (hr.method_17783() == class_239.class_240.field_1332) {
                return bhr.method_17777();
            }
        }
        return player.method_24515();
    }

    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"bp").then(class_2170.method_9247((String)"list").executes(ctx -> BpCommands.listFiles((class_2168)ctx.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").executes(ctx -> BpCommands.startRemove((class_2168)ctx.getSource()))).then(class_2170.method_9247((String)"confirm").executes(ctx -> BpCommands.confirmRemove((class_2168)ctx.getSource())))).then(class_2170.method_9247((String)"cancel").executes(ctx -> BpCommands.cancelRemove((class_2168)ctx.getSource()))))).then(class_2170.method_9247((String)"grab").then(class_2170.method_9244((String)"file", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            class_3222 p = ((class_2168)ctx.getSource()).method_44023();
            if (p == null) {
                return 0;
            }
            String file = StringArgumentType.getString((CommandContext)ctx, (String)"file");
            return BpCommands.autoExportFromLook((class_2168)ctx.getSource(), p, file);
        })))));
    }

    private static int listFiles(class_2168 src) {
        try {
            Path dir = FabricLoader.getInstance().getGameDir().resolve("blueprints");
            if (!Files.exists(dir, new LinkOption[0])) {
                src.method_9226(() -> class_2561.method_43470((String)("Blueprints folder not found: " + String.valueOf(dir))), false);
                return 0;
            }
            try (Stream<Path> s = Files.list(dir);){
                List names = s.filter(p -> p.toString().endsWith(".nbt")).sorted(Comparator.comparing(p -> p.getFileName().toString().toLowerCase())).map(p -> p.getFileName().toString().replaceFirst("\\.nbt$", "")).collect(Collectors.toList());
                if (names.isEmpty()) {
                    src.method_9226(() -> class_2561.method_43470((String)("No blueprints found in " + String.valueOf(dir))), false);
                } else {
                    src.method_9226(() -> class_2561.method_43470((String)("Blueprints (" + names.size() + "): " + String.join((CharSequence)", ", names))), false);
                }
            }
            return 1;
        }
        catch (IOException e) {
            src.method_9213((class_2561)class_2561.method_43470((String)("Failed to list blueprints: " + e.getMessage())));
            return 0;
        }
    }

    public static int startRemove(class_2168 src) {
        class_3222 player = src.method_44023();
        if (player == null) {
            return 0;
        }
        class_3218 world = player.method_51469();
        StructureData data = BpCommands.computeStructureFromLook(src, player);
        if (data.positions().isEmpty()) {
            src.method_9213((class_2561)class_2561.method_43470((String)"Nothing to remove"));
            return 0;
        }
        PENDING_REMOVE.put(player.method_5667(), data.positions());
        PENDING_REMOVE_EXP.put(player.method_5667(), System.currentTimeMillis() + 30000L);
        src.method_9226(() -> class_2561.method_43470((String)("Found " + data.positions().size() + " blocks to remove. Press Enter in the confirm dialog to proceed.")), false);
        try {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new OpenRemoveConfirmPayload(data.positions().size()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 1;
    }

    public static int cancelRemove(class_2168 src) {
        class_3222 p = src.method_44023();
        if (p == null) {
            return 0;
        }
        PENDING_REMOVE.remove(p.method_5667());
        PENDING_REMOVE_EXP.remove(p.method_5667());
        src.method_9226(() -> class_2561.method_43470((String)"Removal canceled."), false);
        return 1;
    }

    public static int confirmRemove(class_2168 src) {
        class_3222 player = src.method_44023();
        if (player == null) {
            return 0;
        }
        UUID id = player.method_5667();
        List<class_2338> positions = PENDING_REMOVE.get(id);
        Long exp = PENDING_REMOVE_EXP.get(id);
        if (positions == null || exp == null || System.currentTimeMillis() > exp) {
            src.method_9213((class_2561)class_2561.method_43470((String)"No pending remove or it expired. Run /bp remove again."));
            PENDING_REMOVE.remove(id);
            PENDING_REMOVE_EXP.remove(id);
            return 0;
        }
        class_3218 world = player.method_51469();
        int removed = 0;
        for (class_2338 wp : positions) {
            if (!world.method_22340(wp) || world.method_8320(wp).method_26215()) continue;
            world.method_8652(wp, class_2246.field_10124.method_9564(), 3);
            ++removed;
        }
        PENDING_REMOVE.remove(id);
        PENDING_REMOVE_EXP.remove(id);
        String msg = "Removed " + removed + " blocks.";
        src.method_9226(() -> class_2561.method_43470((String)msg), true);
        return 1;
    }

    private static StructureData computeStructureFromLook(class_2168 src, class_3222 player) {
        class_2338 start;
        class_3218 world = src.method_9225();
        if (world.method_8320(start = BpCommands.raycastBlock(player, 128.0)).method_26215()) {
            return new StructureData(List.of(), start, start);
        }
        int cap = 8000;
        int maxDistXZ = 32;
        int startY = start.method_10264();
        ArrayDeque<class_2338> q = new ArrayDeque<class_2338>();
        HashSet<Long> seen = new HashSet<Long>();
        ArrayList<class_2338> out = new ArrayList<class_2338>();
        q.add(start);
        seen.add(start.method_10063());
        while (!q.isEmpty() && out.size() < 8000) {
            class_2338 cur = (class_2338)q.removeFirst();
            class_2680 bs = world.method_8320(cur);
            if (bs.method_26215() || cur.method_10264() < startY || BpCommands.isGround(bs) || !bs.method_26227().method_15769()) continue;
            out.add(cur);
            for (class_2350 dir : class_2350.values()) {
                long key;
                class_2338 nxt = cur.method_10093(dir);
                if (Math.abs(nxt.method_10263() - start.method_10263()) + Math.abs(nxt.method_10260() - start.method_10260()) > 32 || nxt.method_10264() < startY || !seen.add(key = nxt.method_10063())) continue;
                q.addLast(nxt);
            }
        }
        class_2338 min = start;
        class_2338 max = start;
        if (!out.isEmpty()) {
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int minZ = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxY = Integer.MIN_VALUE;
            int maxZ = Integer.MIN_VALUE;
            for (class_2338 p : out) {
                if (p.method_10263() < minX) {
                    minX = p.method_10263();
                }
                if (p.method_10264() < minY) {
                    minY = p.method_10264();
                }
                if (p.method_10260() < minZ) {
                    minZ = p.method_10260();
                }
                if (p.method_10263() > maxX) {
                    maxX = p.method_10263();
                }
                if (p.method_10264() > maxY) {
                    maxY = p.method_10264();
                }
                if (p.method_10260() <= maxZ) continue;
                maxZ = p.method_10260();
            }
            min = new class_2338(minX, minY, minZ);
            max = new class_2338(maxX, maxY, maxZ);
        }
        return new StructureData(out, min, max);
    }

    private static void backupPositions(class_2168 src, List<class_2338> positions, String name) {
        try {
            int i;
            if (positions == null || positions.isEmpty()) {
                return;
            }
            class_3218 world = src.method_9225();
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int minZ = Integer.MAX_VALUE;
            for (class_2338 p : positions) {
                if (p.method_10263() < minX) {
                    minX = p.method_10263();
                }
                if (p.method_10264() < minY) {
                    minY = p.method_10264();
                }
                if (p.method_10260() >= minZ) continue;
                minZ = p.method_10260();
            }
            ArrayList<Long> pos = new ArrayList<Long>(positions.size());
            ArrayList<Integer> ids = new ArrayList<Integer>(positions.size());
            for (class_2338 wp : positions) {
                class_2680 bs = world.method_8320(wp);
                if (bs.method_26215()) continue;
                int rx = wp.method_10263() - minX;
                int ry = wp.method_10264() - minY;
                int rz = wp.method_10260() - minZ;
                pos.add(new class_2338(rx, ry, rz).method_10063());
                ids.add(class_2248.field_10651.method_10206((Object)bs));
            }
            long[] posArr = new long[pos.size()];
            int[] idArr = new int[ids.size()];
            for (i = 0; i < pos.size(); ++i) {
                posArr[i] = (Long)pos.get(i);
            }
            for (i = 0; i < ids.size(); ++i) {
                idArr[i] = (Integer)ids.get(i);
            }
            class_2487 tag = new class_2487();
            tag.method_10564("posLongs", posArr);
            tag.method_10539("stateIds", idArr);
            Path dir = FabricLoader.getInstance().getGameDir().resolve("blueprints");
            Files.createDirectories(dir, new FileAttribute[0]);
            Path path = dir.resolve(name + ".nbt");
            try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
                class_2507.method_10634((class_2487)tag, (OutputStream)out);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean isGround(class_2680 bs) {
        class_2248 b = bs.method_26204();
        return b == class_2246.field_10194 || b == class_2246.field_10219 || b == class_2246.field_10566 || b == class_2246.field_10253 || b == class_2246.field_10520 || b == class_2246.field_10102 || b == class_2246.field_10534 || b == class_2246.field_10255 || b == class_2246.field_10362 || b == class_2246.field_10477 || b == class_2246.field_10491 || b == class_2246.field_37576 || b == class_2246.field_28681 || b == class_2246.field_10340 || b == class_2246.field_28888 || b == class_2246.field_27165 || b == class_2246.field_10115 || b == class_2246.field_10508 || b == class_2246.field_10474 || b == class_2246.field_10515 || b == class_2246.field_10471 || b == class_2246.field_22091 || b == class_2246.field_23869;
    }

    private static long columnKey(int x, int z) {
        return (long)x << 32 ^ (long)z & 0xFFFFFFFFL;
    }

    private static int autoExportFromLook(class_2168 src, class_3222 player, String file) {
        class_2338 start;
        class_3218 world = src.method_9225();
        class_2680 startState = world.method_8320(start = BpCommands.raycastBlock(player, 128.0));
        if (startState.method_26215()) {
            src.method_9213((class_2561)class_2561.method_43470((String)"Look at a non-air block to grab"));
            return 0;
        }
        class_2248 startBlock = startState.method_26204();
        int cap = 8000;
        int maxDistXZ = 32;
        int startY = start.method_10264();
        ArrayDeque<class_2338> q = new ArrayDeque<class_2338>();
        HashSet<Long> seen = new HashSet<Long>();
        q.add(start);
        seen.add(start.method_10063());
        ArrayList<class_2338> absPositions = new ArrayList<class_2338>();
        ArrayList<Integer> idList = new ArrayList<Integer>();
        while (!q.isEmpty() && absPositions.size() < 8000) {
            class_2338 cur = (class_2338)q.removeFirst();
            class_2680 bs = world.method_8320(cur);
            if (bs.method_26215() || !bs.method_26227().method_15769() || BpCommands.isGround(bs) || cur.method_10264() < startY) continue;
            absPositions.add(cur);
            idList.add(class_2248.field_10651.method_10206((Object)bs));
            for (class_2350 dir : class_2350.values()) {
                class_2680 nbs;
                class_2338 nxt = cur.method_10093(dir);
                if (Math.abs(nxt.method_10263() - start.method_10263()) + Math.abs(nxt.method_10260() - start.method_10260()) > 32 || nxt.method_10264() < startY || !seen.add(nxt.method_10063()) || (nbs = world.method_8320(nxt)).method_26215() || !nbs.method_26227().method_15769() || BpCommands.isGround(nbs)) continue;
                q.addLast(nxt);
            }
        }
        if (absPositions.isEmpty()) {
            src.method_9213((class_2561)class_2561.method_43470((String)"Nothing to export"));
            return 0;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        for (class_2338 wp : absPositions) {
            if (wp.method_10263() < minX) {
                minX = wp.method_10263();
            }
            if (wp.method_10264() < minY) {
                minY = wp.method_10264();
            }
            if (wp.method_10260() >= minZ) continue;
            minZ = wp.method_10260();
        }
        int n = absPositions.size();
        long[] posArr = new long[n];
        int[] idArr = new int[n];
        for (int i = 0; i < n; ++i) {
            class_2338 wp = (class_2338)absPositions.get(i);
            posArr[i] = new class_2338(wp.method_10263() - minX, wp.method_10264() - minY, wp.method_10260() - minZ).method_10063();
            idArr[i] = (Integer)idList.get(i);
        }
        class_2487 tag = new class_2487();
        tag.method_10564("posLongs", posArr);
        tag.method_10539("stateIds", idArr);
        Path dir = FabricLoader.getInstance().getGameDir().resolve("blueprints");
        Path path = dir.resolve((String)(file.endsWith(".nbt") ? file : file + ".nbt"));
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
                class_2507.method_10634((class_2487)tag, (OutputStream)out);
            }
            String msg = "Grabbed (attached-only, no ground) " + n + " blocks to " + String.valueOf(path) + " (baseY " + startY + ")";
            src.method_9226(() -> class_2561.method_43470((String)msg), true);
            return 1;
        }
        catch (IOException e) {
            src.method_9213((class_2561)class_2561.method_43470((String)("Failed to write blueprint: " + e.getMessage())));
            BlueprintsPlus.LOGGER.error("[Blueprints+] Grab export failed: {}", (Object)e.toString());
            return 0;
        }
    }

    private static void addColumnCollect(class_3218 world, int startY, int cap, int x, int z, ArrayList<class_2338> absPositions, ArrayList<Integer> idList) {
        class_2680 bs;
        class_2680 bs2;
        int y;
        int repY = Integer.MIN_VALUE;
        int maxSearch = 24;
        for (int dy = 0; dy <= maxSearch; ++dy) {
            class_2680 bsDn;
            class_2680 bsUp;
            int upY = startY + dy;
            int downY = startY - dy;
            if (upY <= world.method_31600() && !(bsUp = world.method_8320(new class_2338(x, upY, z))).method_26215() && !BpCommands.isGround(bsUp)) {
                repY = upY;
                break;
            }
            if (downY < world.method_31607() || (bsDn = world.method_8320(new class_2338(x, downY, z))).method_26215() || BpCommands.isGround(bsDn)) continue;
            repY = downY;
            break;
        }
        if (repY == Integer.MIN_VALUE) {
            return;
        }
        for (y = repY; y <= world.method_31600() && absPositions.size() < cap && !(bs2 = world.method_8320(new class_2338(x, y, z))).method_26215() && !BpCommands.isGround(bs2); ++y) {
            absPositions.add(new class_2338(x, y, z));
            idList.add(class_2248.field_10651.method_10206((Object)bs2));
        }
        for (y = repY - 1; y >= world.method_31607() && absPositions.size() < cap && !(bs = world.method_8320(new class_2338(x, y, z))).method_26215() && !BpCommands.isGround(bs); --y) {
            absPositions.add(new class_2338(x, y, z));
            idList.add(class_2248.field_10651.method_10206((Object)bs));
        }
    }

    private record StructureData(List<class_2338> positions, class_2338 min, class_2338 max) {
    }
}

