/*
 * Decompiled with CFR 0.152.
 */
package blueprintsplus.network;

import blueprintsplus.command.BpCommands;
import blueprintsplus.network.PlaceBlueprintPayload;
import blueprintsplus.network.RequestServerDataPayload;
import blueprintsplus.network.RequestServerDeletePayload;
import blueprintsplus.network.RequestServerListPayload;
import blueprintsplus.network.RequestServerRemoveConfirmPayload;
import blueprintsplus.network.RequestServerRenamePayload;
import blueprintsplus.network.ServerDataPayload;
import blueprintsplus.network.ServerListPayload;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public final class ServerHandlers {
    private ServerHandlers() {
    }

    public static void register() {
        ServerPlayNetworking.registerGlobalReceiver(PlaceBlueprintPayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            if (player == null) {
                return;
            }
            if (!player.method_31549().field_7477) {
                return;
            }
            player.method_51469().method_8503().execute(() -> {
                class_3218 world = player.method_51469();
                int n = Math.min(payload.count(), 8000);
                for (int i = 0; i < n; ++i) {
                    class_2338 pos = payload.getPos(i);
                    class_2680 state = payload.getState(i);
                    if (!world.method_22340(pos)) continue;
                    world.method_8652(pos, state, 3);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(RequestServerListPayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            if (player == null) {
                return;
            }
            player.method_51469().method_8503().execute(() -> {
                List<String> names = ServerHandlers.readServerBlueprintNames();
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ServerListPayload(names));
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(RequestServerDataPayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            if (player == null) {
                return;
            }
            String name = payload.name();
            player.method_51469().method_8503().execute(() -> {
                ServerDataPayload data = ServerHandlers.loadServerBlueprintData(name);
                if (data != null) {
                    ServerPlayNetworking.send((class_3222)player, (class_8710)data);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(RequestServerDeletePayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            if (player == null) {
                return;
            }
            String name = payload.name();
            player.method_51469().method_8503().execute(() -> {
                ServerHandlers.deleteServerBlueprint(name);
                List<String> names = ServerHandlers.readServerBlueprintNames();
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ServerListPayload(names));
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(RequestServerRemoveConfirmPayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            if (player == null) {
                return;
            }
            player.method_51469().method_8503().execute(() -> BpCommands.confirmRemove(player.method_5671()));
        });
        ServerPlayNetworking.registerGlobalReceiver(RequestServerRenamePayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            if (player == null) {
                return;
            }
            String oldName = payload.oldName();
            String newName = payload.newName();
            player.method_51469().method_8503().execute(() -> {
                ServerHandlers.renameServerBlueprint(oldName, newName);
                List<String> names = ServerHandlers.readServerBlueprintNames();
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ServerListPayload(names));
            });
        });
    }

    private static List<String> readServerBlueprintNames() {
        List<String> list;
        block9: {
            Path dir = FabricLoader.getInstance().getGameDir().resolve("blueprints");
            if (!Files.exists(dir, new LinkOption[0])) {
                return List.of();
            }
            Stream<Path> s = Files.list(dir);
            try {
                list = s.filter(p -> p.getFileName().toString().toLowerCase().endsWith(".nbt")).sorted(Comparator.comparing(p -> p.getFileName().toString().toLowerCase())).map(p -> p.getFileName().toString().replaceFirst("\\.nbt$", "")).collect(Collectors.toList());
                if (s == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return List.of();
                }
            }
            s.close();
        }
        return list;
    }

    private static ServerDataPayload loadServerBlueprintData(String name) {
        try {
            int[] stateIds;
            class_2487 tag;
            if (name == null || name.isEmpty()) {
                return null;
            }
            Path dir = FabricLoader.getInstance().getGameDir().resolve("blueprints");
            Path path = dir.resolve((String)(name.endsWith(".nbt") ? name : name + ".nbt"));
            if (!Files.exists(path, new LinkOption[0])) {
                return null;
            }
            try {
                tag = class_2507.method_30613((Path)path, (class_2505)class_2505.method_53898());
            }
            catch (Throwable t) {
                tag = class_2507.method_10633((Path)path);
            }
            if (tag == null) {
                return null;
            }
            long[] posLongs = tag.method_10565("posLongs");
            int n = Math.min(posLongs.length, (stateIds = tag.method_10561("stateIds")).length);
            if (n > 8000) {
                long[] np = new long[8000];
                int[] ni = new int[8000];
                System.arraycopy(posLongs, 0, np, 0, 8000);
                System.arraycopy(stateIds, 0, ni, 0, 8000);
                posLongs = np;
                stateIds = ni;
            }
            return new ServerDataPayload(name, posLongs, stateIds);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void deleteServerBlueprint(String name) {
        try {
            if (name == null || name.isEmpty()) {
                return;
            }
            Path dir = FabricLoader.getInstance().getGameDir().resolve("blueprints");
            Path path = dir.resolve((String)(name.endsWith(".nbt") ? name : name + ".nbt"));
            if (Files.exists(path, new LinkOption[0])) {
                Files.delete(path);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void renameServerBlueprint(String oldName, String newName) {
        try {
            if (oldName == null || oldName.isEmpty() || newName == null || newName.isEmpty()) {
                return;
            }
            Path dir = FabricLoader.getInstance().getGameDir().resolve("blueprints");
            Files.createDirectories(dir, new FileAttribute[0]);
            Path src = dir.resolve((String)(oldName.endsWith(".nbt") ? oldName : oldName + ".nbt"));
            Path dst = dir.resolve((String)(newName.endsWith(".nbt") ? newName : newName + ".nbt"));
            if (!Files.exists(src, new LinkOption[0])) {
                return;
            }
            if (Files.exists(dst, new LinkOption[0])) {
                String base = newName;
                int i = 1;
                do {
                    dst = dir.resolve(base + "_" + i + ".nbt");
                    ++i;
                } while (Files.exists(dst, new LinkOption[0]));
            }
            Files.move(src, dst, new CopyOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

