/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.wilderflowers.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.Nullable;

public class FlowerPetalParticle
extends SingleQuadParticle {
    private final float yRot;
    private final float yOffset;

    protected FlowerPetalParticle(ClientLevel level, double x, double y, double z, double vx, double vy, double vz, TextureAtlasSprite sprite) {
        super(level, x, y, z, vx, vy, vz, sprite);
        this.lifetime = 100 + this.random.nextInt(20);
        this.gravity = 0.01f;
        this.yd = -0.08f;
        this.xd = (-0.5 + (double)this.random.nextFloat()) / 10.0;
        this.zd = (-0.5 + (double)this.random.nextFloat()) / 10.0;
        this.quadSize = 0.5f;
        this.yOffset = this.random.nextFloat() / 10.0f;
        this.yRot = (float)(1.5707963267948966 * (double)this.random.nextInt(4));
    }

    public void tick() {
        super.tick();
        this.xd = Mth.clamp((double)(this.xd + (double)(this.random.nextFloat() / 1000.0f * (float)(this.random.nextBoolean() ? 1 : -1))), (double)-0.05f, (double)0.05f);
        this.zd = Mth.clamp((double)(this.zd + (double)(this.random.nextFloat() / 1000.0f * (float)(this.random.nextBoolean() ? 1 : -1))), (double)-0.05f, (double)0.05f);
    }

    protected SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.TRANSLUCENT;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType particleType, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            FlowerPetalParticle p = new FlowerPetalParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprites.get(random));
            return p;
        }
    }
}

