/*
 * Decompiled with CFR 0.152.
 */
package com.davigj.wilderflowers.client.event;

import com.davigj.wilderflowers.common.item.FlowerGarlandItem;
import com.davigj.wilderflowers.core.registry.WFItems;
import com.davigj.wilderflowers.core.registry.WFParticleTypes;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;

public class FlowerGarlandEvent {
    private static final float STEP_LENGTH = 2.0f;
    private static final float PARTICLE_CHANCE = 0.25f;
    private static final float PARTICLE_CHANCE_SPRINTING = 0.75f;
    private static final float TWO_PARTICLE_CHANCE = 0.5f;
    private static final Map<UUID, Vec3> prevPositions = new HashMap<UUID, Vec3>();
    private static final Map<Item, SimpleParticleType> PARTICLES = new HashMap<Item, SimpleParticleType>();

    public static void tick(Minecraft mc) {
        ParticleStatus status = (ParticleStatus)mc.f_91066_.m_231929_().m_231551_();
        LocalPlayer player = mc.f_91074_;
        if (status == ParticleStatus.MINIMAL) {
            return;
        }
        if (player == null) {
            return;
        }
        Item headItem = player.m_6844_(EquipmentSlot.HEAD).m_41720_();
        if (headItem instanceof FlowerGarlandItem && player.m_20096_()) {
            UUID playerId = player.m_20148_();
            Vec3 playerPos = player.m_20182_();
            if (!prevPositions.containsKey(playerId)) {
                prevPositions.put(playerId, playerPos);
                return;
            }
            Vec3 prevPlayerPos = prevPositions.get(playerId);
            double distance = playerPos.m_82554_(prevPlayerPos);
            if (distance > 2.0) {
                float f = player.m_217043_().m_188501_();
                float f2 = player.m_20142_() ? 0.75f : 0.25f;
                if (f <= f2) {
                    Vec3 movement = player.m_20184_().m_82541_().m_82548_();
                    SimpleParticleType particle = PARTICLES.get(headItem);
                    if (particle != null) {
                        int particleCount = player.m_217043_().m_188501_() <= 0.5f ? 1 : 2;
                        for (int i = 0; i < particleCount; ++i) {
                            player.m_9236_().m_7106_((ParticleOptions)particle, playerPos.m_7096_() + movement.f_82479_ / 2.0, playerPos.m_7098_() + 1.0 + (double)player.m_217043_().m_188501_() * 0.4, playerPos.m_7094_() + movement.f_82481_ / 2.0, 0.0, 0.0, 0.0);
                        }
                    }
                    prevPositions.put(playerId, playerPos);
                }
            }
        }
    }

    static {
        PARTICLES.put(WFItems.CHEERY_WILDFLOWER_GARLAND.get(), (SimpleParticleType)WFParticleTypes.CHEERY_PETAL.get());
        PARTICLES.put(WFItems.PLAYFUL_WILDFLOWER_GARLAND.get(), (SimpleParticleType)WFParticleTypes.PLAYFUL_PETAL.get());
        PARTICLES.put(WFItems.HOPEFUL_WILDFLOWER_GARLAND.get(), (SimpleParticleType)WFParticleTypes.HOPEFUL_PETAL.get());
        PARTICLES.put(WFItems.MOODY_WILDFLOWER_GARLAND.get(), (SimpleParticleType)WFParticleTypes.MOODY_PETAL.get());
    }
}

