/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber(modid="volcano")
public class VolcanoManager {
    private static final VolcanoManager INSTANCE = new VolcanoManager();
    private final List<ActiveVolcano> volcanoes = new ArrayList<ActiveVolcano>();

    public static VolcanoManager getInstance() {
        return INSTANCE;
    }

    public void activateVolcano(BlockPos center, ServerLevel level) {
        this.volcanoes.add(new ActiveVolcano(center, level));
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        INSTANCE.tick();
    }

    private void tick() {
        Iterator<ActiveVolcano> iterator = this.volcanoes.iterator();
        while (iterator.hasNext()) {
            ActiveVolcano v = iterator.next();
            v.tick();
            if (!v.isDead()) continue;
            iterator.remove();
        }
    }

    private static class ActiveVolcano {
        private final BlockPos center;
        private final ServerLevel level;
        private int tickCount = 0;
        private static final int MAX_HEIGHT = 100;
        private static final int RADIUS = 40;
        private static final int CRATER_RADIUS_BOTTOM = 3;
        private static final int CRATER_RADIUS_TOP = 8;
        private Phase phase = Phase.RISING;
        private int currentMaxHeight = 0;
        private final Map<Long, Integer> originalHeights = new HashMap<Long, Integer>();
        private final Random random = new Random();
        private int lavaLevel;
        private final List<FallingBlockEntity> activeFireballs = new ArrayList<FallingBlockEntity>();

        public ActiveVolcano(BlockPos center, ServerLevel level) {
            this.center = center;
            this.level = level;
            this.lavaLevel = center.getY();
        }

        public boolean isDead() {
            return false;
        }

        public void tick() {
            ++this.tickCount;
            switch (this.phase.ordinal()) {
                case 0: {
                    if (this.tickCount % 2 != 0) break;
                    this.tickRising();
                    break;
                }
                case 1: {
                    if (this.tickCount % 20 != 0) break;
                    this.tickFilling();
                    break;
                }
                case 2: {
                    this.tickActive();
                }
            }
            this.tickFireballs();
        }

        private void tickRising() {
            if (this.currentMaxHeight < 100) {
                if (this.tickCount % 40 == 0) {
                    ++this.currentMaxHeight;
                }
            } else {
                this.phase = Phase.FILLING;
                return;
            }
            for (int i = 0; i < 200; ++i) {
                int dz;
                int dx = this.random.nextInt(81) - 40;
                double dist = Math.sqrt(dx * dx + (dz = this.random.nextInt(81) - 40) * dz);
                if (dist > 40.0) continue;
                BlockPos pos = this.center.offset(dx, 0, dz);
                long posKey = pos.asLong();
                if (!this.originalHeights.containsKey(posKey)) {
                    this.originalHeights.put(posKey, this.level.getHeight(Heightmap.Types.MOTION_BLOCKING, pos.getX(), pos.getZ()));
                }
                int originalY = this.originalHeights.get(posKey);
                double targetHeightOffset = (double)this.currentMaxHeight * (1.0 - dist / 40.0);
                if (targetHeightOffset < 0.0) {
                    targetHeightOffset = 0.0;
                }
                int targetY = originalY + (int)targetHeightOffset;
                int currentY = this.level.getHeight(Heightmap.Types.MOTION_BLOCKING, pos.getX(), pos.getZ());
                if (currentY >= targetY) continue;
                this.raiseColumn(pos.getX(), pos.getZ(), currentY);
            }
        }

        private void raiseColumn(int x, int z, int topY) {
            BlockPos topPos = new BlockPos(x, topY, z);
            BlockState topState = this.level.getBlockState(topPos.below());
            if (!topState.isAir()) {
                this.level.setBlockAndUpdate(topPos, topState);
                this.level.setBlockAndUpdate(topPos.below(), Blocks.BASALT.defaultBlockState());
            }
        }

        private void tickFilling() {
            int safeHeight = 75;
            int targetLavaSurface = this.center.getY() + safeHeight;
            if (this.lavaLevel < targetLavaSurface) {
                ++this.lavaLevel;
                double progress = (double)(this.lavaLevel - this.center.getY()) / 100.0;
                int currentCraterRadius = (int)(3.0 + 5.0 * progress);
                for (int dx = -currentCraterRadius; dx <= currentCraterRadius; ++dx) {
                    for (int dz = -currentCraterRadius; dz <= currentCraterRadius; ++dz) {
                        if (dx * dx + dz * dz > currentCraterRadius * currentCraterRadius) continue;
                        BlockPos p = new BlockPos(this.center.getX() + dx, this.lavaLevel, this.center.getZ() + dz);
                        this.level.setBlockAndUpdate(p, Blocks.LAVA.defaultBlockState());
                    }
                }
            } else {
                this.phase = Phase.ACTIVE;
            }
        }

        private void tickActive() {
            if (this.tickCount % 10 == 0) {
                BlockPos top = this.center.above(80);
                this.spawnLongDistanceParticles(this.level, (ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)top.getX() + 0.5, top.getY() + 5, (double)top.getZ() + 0.5, 20, 4.0, 5.0, 4.0, 0.05);
                this.spawnLongDistanceParticles(this.level, (ParticleOptions)ParticleTypes.FLAME, (double)top.getX() + 0.5, top.getY() + 5, (double)top.getZ() + 0.5, 10, 2.0, 3.0, 2.0, 0.05);
            }
            if (this.tickCount % 60 == 0) {
                this.shootFireball();
            }
            if (this.tickCount % 100 == 0) {
                this.spawnLavaOnSlope();
                this.spawnLavaDrip();
            }
        }

        private void spawnLongDistanceParticles(ServerLevel level, ParticleOptions particle, double x, double y, double z, int count, double dx, double dy, double dz, double speed) {
            for (ServerPlayer player : level.players()) {
                BlockPos blockPos = new BlockPos((int)x, (int)y, (int)z);
                if (!(player.blockPosition().distSqr((Vec3i)blockPos) < 1048576.0)) continue;
                level.sendParticles(player, particle, true, x, y, z, count, dx, dy, dz, speed);
            }
        }

        private void spawnLavaDrip() {
            int dz;
            int safeHeight;
            int rimHeight = safeHeight = 75;
            int angle = this.random.nextInt(360);
            double rad = Math.toRadians(angle);
            int currentCraterRadius = 8;
            int dx = (int)(Math.cos(rad) * (double)(currentCraterRadius + 1));
            BlockPos pos = this.center.offset(dx, rimHeight, dz = (int)(Math.sin(rad) * (double)(currentCraterRadius + 1)));
            if (this.level.getBlockState(pos).isAir()) {
                this.level.setBlockAndUpdate(pos, Blocks.LAVA.defaultBlockState());
            }
        }

        private void shootFireball() {
            BlockPos spawnPos = this.center.above(80);
            FallingBlockEntity entity = FallingBlockEntity.fall((Level)this.level, (BlockPos)spawnPos, (BlockState)Blocks.MAGMA_BLOCK.defaultBlockState());
            double angle = this.random.nextDouble() * 2.0 * Math.PI;
            double speed = 0.8 + this.random.nextDouble() * 3.7;
            double vx = Math.cos(angle) * speed;
            double vz = Math.sin(angle) * speed;
            double vy = 1.5 + this.random.nextDouble() * 2.5;
            entity.setDeltaMovement(vx, vy, vz);
            entity.setHurtsEntities(2.0f, 40);
            this.level.addFreshEntity((Entity)entity);
            this.activeFireballs.add(entity);
            this.level.playSound(null, spawnPos, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.BLOCKS, 5.0f, 1.0f);
        }

        private void tickFireballs() {
            Iterator<FallingBlockEntity> it = this.activeFireballs.iterator();
            while (it.hasNext()) {
                FallingBlockEntity entity = it.next();
                if (!entity.isRemoved()) {
                    double time = (double)entity.tickCount * 0.6;
                    double radius = 1.2;
                    double px = Math.cos(time) * radius;
                    double pz = Math.sin(time) * radius;
                    this.spawnLongDistanceParticles(this.level, (ParticleOptions)ParticleTypes.FLAME, entity.getX() + px, entity.getY() + 0.5, entity.getZ() + pz, 1, 0.0, 0.0, 0.0, 0.0);
                    this.spawnLongDistanceParticles(this.level, (ParticleOptions)ParticleTypes.SMOKE, entity.getX() - px, entity.getY() + 0.5, entity.getZ() - pz, 1, 0.0, 0.0, 0.0, 0.0);
                    this.spawnLongDistanceParticles(this.level, (ParticleOptions)ParticleTypes.LAVA, entity.getX(), entity.getY() + 0.5, entity.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
                }
                boolean exploded = false;
                if (entity.isRemoved()) {
                    BlockPos pos = entity.blockPosition();
                    if (this.level.getBlockState(pos).is(Blocks.MAGMA_BLOCK)) {
                        this.explodeFireball((Entity)entity, pos);
                        exploded = true;
                        this.level.removeBlock(pos, false);
                    }
                    it.remove();
                    continue;
                }
                if (!entity.onGround() && !entity.horizontalCollision && !entity.verticalCollision) continue;
                this.explodeFireball((Entity)entity, entity.blockPosition());
                exploded = true;
                entity.discard();
                it.remove();
            }
        }

        private void explodeFireball(Entity entity, BlockPos pos) {
            double safeRadiusSq;
            double distSq = pos.distSqr((Vec3i)this.center);
            boolean destructive = distSq > (safeRadiusSq = 2025.0);
            Level.ExplosionInteraction interaction = destructive ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE;
            this.level.explode(null, entity.getX(), entity.getY(), entity.getZ(), 4.0f, true, interaction);
            if (this.level.getBlockState(pos).isAir() || this.level.getBlockState(pos).canBeReplaced()) {
                this.level.setBlockAndUpdate(pos, Blocks.FIRE.defaultBlockState());
            }
            this.spawnLongDistanceParticles(this.level, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, entity.getX(), entity.getY(), entity.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
        }

        private void spawnLavaOnSlope() {
            int dz;
            int dx = this.random.nextInt(80) - 40;
            if (dx * dx + (dz = this.random.nextInt(80) - 40) * dz > 1600 || dx * dx + dz * dz < 128) {
                return;
            }
            BlockPos pos = this.center.offset(dx, 0, dz);
            int y = this.level.getHeight(Heightmap.Types.MOTION_BLOCKING, pos.getX(), pos.getZ());
            BlockPos target = new BlockPos(pos.getX(), y, pos.getZ());
            if (this.level.getBlockState(target).isAir()) {
                this.level.setBlockAndUpdate(target, Blocks.LAVA.defaultBlockState());
            }
        }

        static enum Phase {
            RISING,
            FILLING,
            ACTIVE;

        }
    }
}

