/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.client;

import com.blackgear.platform.client.forge.GameRenderingImpl;
import com.blackgear.platform.client.renderer.model.geom.ModelLayerLocation;
import com.blackgear.platform.client.renderer.model.geom.ModelLayers;
import com.blackgear.platform.client.renderer.model.geom.builder.LayerDefinition;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.SkullBlock;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.GenericHeadModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class GameRendering {
    public static Map<ModelLayerLocation, LayerDefinition> MODEL_LAYERS = new ConcurrentHashMap<ModelLayerLocation, LayerDefinition>();
    public static final Map<Item, ModelResourceLocation> HAND_HELD_MODELS = new ConcurrentHashMap<Item, ModelResourceLocation>();
    public static final Map<SkullBlock.ISkullType, ResourceLocation> TEXTURE_BY_SKULL = new ConcurrentHashMap<SkullBlock.ISkullType, ResourceLocation>();
    public static final Map<SkullBlock.ISkullType, GenericHeadModel> MODEL_BY_SKULL = new ConcurrentHashMap<SkullBlock.ISkullType, GenericHeadModel>();

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerBlockColors(Consumer<BlockColorEvent> listener) {
        GameRenderingImpl.registerBlockColors(listener);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerBlockRenderers(Consumer<BlockRendererEvent> listener) {
        GameRenderingImpl.registerBlockRenderers(listener);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerEntityRenderers(Consumer<EntityRendererEvent> listener) {
        GameRenderingImpl.registerEntityRenderers(listener);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerBlockEntityRenderers(Consumer<BlockEntityRendererEvent> listener) {
        GameRenderingImpl.registerBlockEntityRenderers(listener);
    }

    public static void registerModelLayers(Consumer<ModelLayerEvent> listener) {
        ModelLayerEvent event = (layer, provider) -> {
            if (MODEL_LAYERS.putIfAbsent(layer, provider) != null) {
                throw new IllegalArgumentException(String.format("Model layer %s is already registered!", layer));
            }
            ModelLayers.ALL_MODELS.add(layer);
        };
        listener.accept(event);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerSpecialModels(Consumer<SpecialModelEvent> listener) {
        GameRenderingImpl.registerSpecialModels(listener);
    }

    public static void registerHandHeldModels(Consumer<HandHeldModelEvent> listener) {
        listener.accept(HAND_HELD_MODELS::put);
    }

    public static void registerSkullRenderers(Consumer<SkullRendererEvent> listener) {
        listener.accept(new SkullRendererEvent(){

            @Override
            public void registerSkullModel(SkullBlock.ISkullType type, GenericHeadModel model) {
                MODEL_BY_SKULL.put(type, model);
            }

            @Override
            public void registerSkullTexture(SkullBlock.ISkullType type, ResourceLocation texture) {
                TEXTURE_BY_SKULL.put(type, texture);
            }
        });
    }

    public static interface ModelLayerEvent {
        public void register(ModelLayerLocation var1, LayerDefinition var2);
    }

    public static interface HandHeldModelEvent {
        public void register(Item var1, ModelResourceLocation var2);
    }

    public static interface SkullRendererEvent {
        public void registerSkullModel(SkullBlock.ISkullType var1, GenericHeadModel var2);

        public void registerSkullTexture(SkullBlock.ISkullType var1, ResourceLocation var2);
    }

    public static interface SpecialModelEvent {
        public void register(ResourceLocation var1);

        public void register(ResourceLocation ... var1);
    }

    public static interface BlockEntityRendererEvent {
        public <E extends TileEntity> void register(TileEntityType<E> var1, Function<TileEntityRendererDispatcher, TileEntityRenderer<? super E>> var2);
    }

    public static interface EntityRendererEvent {
        public <E extends Entity> void register(EntityType<? extends E> var1, Function<EntityRendererManager, EntityRenderer<E>> var2);
    }

    public static interface BlockRendererEvent {
        public void register(RenderType var1, Block ... var2);

        public void register(RenderType var1, Fluid ... var2);
    }

    public static interface BlockColorEvent {
        public void register(IItemColor var1, IItemProvider ... var2);

        public void register(IBlockColor var1, Block ... var2);
    }
}

