/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.client.animator;

import com.blackgear.platform.client.renderer.model.NeoHierarchicalModel;
import com.blackgear.platform.client.renderer.model.animation.AnimationChannel;
import com.blackgear.platform.client.renderer.model.animation.AnimationDefinition;
import com.blackgear.platform.client.renderer.model.animation.Keyframe;
import com.blackgear.platform.client.renderer.model.geom.NeoModelPart;
import com.blackgear.platform.common.entity.resource.AnimationState;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class KeyframeAnimator {
    private static final Vector3f ANIMATION_VECTOR_CACHE = new Vector3f();

    public static void animate(NeoHierarchicalModel<?> model, AnimationState state, AnimationDefinition definition, float time) {
        KeyframeAnimator.animate(model, state, definition, time, 1.0f);
    }

    public static void animateWalk(NeoHierarchicalModel<?> model, AnimationDefinition definition, float limbSwing, float limbSwingAmount, float maxSpeed, float scaleFactor) {
        long accumulatedTime = (long)(limbSwing * 50.0f * maxSpeed);
        float scale = Math.min(limbSwingAmount * scaleFactor, 1.0f);
        KeyframeAnimator.animate(model, definition, accumulatedTime, scale);
    }

    public static void animate(NeoHierarchicalModel<?> model, AnimationState state, AnimationDefinition definition, float time, float speed) {
        state.updateTime(time, speed);
        state.ifStarted(animationState -> KeyframeAnimator.animate(model, definition, animationState.getAccumulatedTime(), 1.0f));
    }

    public static void applyStatic(NeoHierarchicalModel<?> model, AnimationDefinition definition) {
        KeyframeAnimator.animate(model, definition, 0L, 1.0f);
    }

    private static void animate(NeoHierarchicalModel<?> model, AnimationDefinition definition, long accumulatedTime, float scale) {
        float elapsed = KeyframeAnimator.getElapsedSeconds(definition, accumulatedTime);
        for (Map.Entry<String, List<AnimationChannel>> animations : definition.boneAnimations().entrySet()) {
            Optional<NeoModelPart> optional = model.getAnyDescendantWithName(animations.getKey());
            List<AnimationChannel> channels = animations.getValue();
            optional.ifPresent(part -> channels.forEach(channel -> {
                Keyframe[] frames = channel.keyframes();
                int frameIndex = Math.max(0, MathHelper.func_199093_a((int)0, (int)frames.length, i -> elapsed <= frames[i].timestamp()) - 1);
                int nextFrameIndex = Math.min(frames.length - 1, frameIndex + 1);
                Keyframe frame = frames[frameIndex];
                Keyframe nextFrame = frames[nextFrameIndex];
                float remaining = elapsed - frame.timestamp();
                float delta = nextFrameIndex != frameIndex ? MathHelper.func_76131_a((float)(remaining / (nextFrame.timestamp() - frame.timestamp())), (float)0.0f, (float)1.0f) : 0.0f;
                nextFrame.interpolation().apply(ANIMATION_VECTOR_CACHE, delta, frames, frameIndex, nextFrameIndex, scale);
                channel.target().apply((NeoModelPart)part, ANIMATION_VECTOR_CACHE);
            }));
        }
    }

    private static float getElapsedSeconds(AnimationDefinition definition, long accumulatedTime) {
        float seconds = (float)accumulatedTime / 1000.0f;
        return definition.looping() ? seconds % definition.lengthInSeconds() : seconds;
    }
}

