/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.client.animator;

import com.blackgear.platform.client.animator.base.AnimatedChannel;
import com.blackgear.platform.client.renderer.model.NeoHierarchicalModel;
import com.blackgear.platform.client.renderer.model.geom.NeoModelPart;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MathAnimator {
    public final Map<String, List<AnimatedChannel>> animationsByBone;

    public MathAnimator(Map<String, List<AnimatedChannel>> animationsByBone) {
        this.animationsByBone = animationsByBone;
    }

    public static void animated(NeoHierarchicalModel<?> model, float animationProgress, MathAnimator builder) {
        float animTime = animationProgress / 20.0f;
        for (Map.Entry<String, List<AnimatedChannel>> animation : builder.animationsByBone.entrySet()) {
            Optional<NeoModelPart> entry = model.getAnyDescendantWithName(animation.getKey());
            List<AnimatedChannel> channels = animation.getValue();
            entry.ifPresent(part -> channels.forEach(channel -> Arrays.stream(channel.targets).forEach(point -> {
                Vector3f vector = new Vector3f(point.getX(animTime), point.getY(animTime), point.getZ(animTime));
                point.target().apply((NeoModelPart)part, vector);
            })));
        }
    }

    public static class Builder {
        private final Map<String, List<AnimatedChannel>> animationByBone = Maps.newHashMap();

        public Builder addAnimation(String bone, AnimatedChannel animation) {
            this.animationByBone.computeIfAbsent(bone, key -> Lists.newArrayList()).add(animation);
            return this;
        }

        public MathAnimator build() {
            return new MathAnimator(this.animationByBone);
        }
    }
}

