/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.client.event;

import com.blackgear.platform.client.resource.NearPlane;
import com.blackgear.platform.core.mixin.access.CameraAccessor;
import com.blackgear.platform.core.util.event.Event;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.Iterator;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;

public class FogRenderEvents {
    public static final Event<FogColor> FOG_COLOR = Event.create(FogColor.class);
    public static final Event<FogRendering> FOG_RENDERING = Event.create(FogRendering.class);

    protected static BlockState getStateOnCamera(ActiveRenderInfo camera) {
        if (camera.func_216786_h()) {
            NearPlane plane = NearPlane.getNearPlane(camera);
            CameraAccessor access = (CameraAccessor)camera;
            Iterator<Vector3d> iterator = Arrays.asList(plane.forward, plane.getTopLeft(), plane.getTopRight(), plane.getBottomLeft(), plane.getBottomRight()).iterator();
            if (iterator.hasNext()) {
                Vector3d vector = iterator.next();
                Vector3d position = camera.func_216785_c().func_178787_e(vector);
                return access.getLevel().func_180495_p(new BlockPos(position));
            }
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    @FunctionalInterface
    public static interface FogColor {
        public void setupColor(GameRenderer var1, ColorContext var2, float var3);
    }

    @FunctionalInterface
    public static interface FogRendering {
        public void setupRendering(GameRenderer var1, RenderContext var2, float var3);
    }

    public static interface RenderContext {
        public ActiveRenderInfo camera();

        public float fogStart();

        public float fogEnd();

        public float fogDensity();

        public void fogStart(float var1);

        public void fogEnd(float var1);

        public void fogDensity(float var1);

        default public void fogMode(GlStateManager.FogMode mode) {
            RenderSystem.fogMode((GlStateManager.FogMode)mode);
        }

        default public void setupNvFogDistance() {
            RenderSystem.setupNvFogDistance();
        }

        default public BlockState getStateAtCamera() {
            return FogRenderEvents.getStateOnCamera(this.camera());
        }

        public boolean isValid();

        public void build();
    }

    public static interface ColorContext {
        public ActiveRenderInfo getCamera();

        public float getRed();

        public float getGreen();

        public float getBlue();

        public void setRed(float var1);

        public void setGreen(float var1);

        public void setBlue(float var1);

        default public BlockState getStateAtCamera() {
            return FogRenderEvents.getStateOnCamera(this.getCamera());
        }

        public boolean isValid();

        public void build();
    }
}

