/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.client.forge;

import com.blackgear.platform.client.GameRendering;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class GameRenderingImpl {
    public static void registerBlockColors(Consumer<GameRendering.BlockColorEvent> listener) {
        final IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        listener.accept(new GameRendering.BlockColorEvent(){

            @Override
            public void register(IItemColor color, IItemProvider ... items) {
                bus.addListener(event -> event.getItemColors().func_199877_a(color, items));
            }

            @Override
            public void register(IBlockColor color, Block ... blocks) {
                bus.addListener(event -> event.getBlockColors().func_186722_a(color, blocks));
            }
        });
    }

    public static void registerBlockRenderers(Consumer<GameRendering.BlockRendererEvent> listener) {
        listener.accept(new GameRendering.BlockRendererEvent(){

            @Override
            public void register(RenderType type, Block ... blocks) {
                Arrays.stream(blocks).forEach(block -> RenderTypeLookup.setRenderLayer((Block)block, (RenderType)type));
            }

            @Override
            public void register(RenderType type, Fluid ... fluids) {
                Arrays.stream(fluids).forEach(fluid -> RenderTypeLookup.setRenderLayer((Fluid)fluid, (RenderType)type));
            }
        });
    }

    public static void registerEntityRenderers(Consumer<GameRendering.EntityRendererEvent> listener) {
        listener.accept(new GameRendering.EntityRendererEvent(){

            @Override
            public <E extends Entity> void register(EntityType<? extends E> type, Function<EntityRendererManager, EntityRenderer<E>> renderer) {
                RenderingRegistry.registerEntityRenderingHandler(type, renderer::apply);
            }
        });
    }

    public static void registerBlockEntityRenderers(Consumer<GameRendering.BlockEntityRendererEvent> listener) {
        listener.accept(ClientRegistry::bindTileEntityRenderer);
    }

    public static void registerSpecialModels(Consumer<GameRendering.SpecialModelEvent> listener) {
        Consumer<ModelRegistryEvent> exporter = event -> listener.accept(new GameRendering.SpecialModelEvent(){

            @Override
            public void register(ResourceLocation model) {
                ModelLoader.addSpecialModel((ResourceLocation)model);
            }

            @Override
            public void register(ResourceLocation ... models) {
                Arrays.stream(models).forEach(this::register);
            }
        });
        FMLJavaModLoadingContext.get().getModEventBus().addListener(exporter);
    }
}

