/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.client.renderer;

import com.blackgear.platform.client.renderer.NeoRenderLayerParent;
import com.blackgear.platform.client.renderer.model.NeoEntityModel;
import com.blackgear.platform.client.renderer.model.layer.NeoRenderLayer;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public abstract class NeoLivingEntityRenderer<T extends LivingEntity, M extends NeoEntityModel<T>>
extends EntityRenderer<T>
implements NeoRenderLayerParent<T, M> {
    protected M model;
    protected final List<NeoRenderLayer<T, M>> layers = Lists.newArrayList();

    protected NeoLivingEntityRenderer(EntityRendererManager dispatcher, M model, float shadowRadius) {
        super(dispatcher);
        this.model = model;
        this.field_76989_e = shadowRadius;
    }

    protected final boolean addLayer(NeoRenderLayer<T, M> layer) {
        return this.layers.add(layer);
    }

    @Override
    public M getModel() {
        return this.model;
    }

    public void render(T entity, float entityYaw, float partialTicks, MatrixStack stack, IRenderTypeBuffer buffer, int packedLight) {
        Direction direction;
        float ageInTicks;
        stack.func_227860_a_();
        ((NeoEntityModel)((Object)this.model)).attackTime = this.getAttackAnim(entity, partialTicks);
        ((NeoEntityModel)((Object)this.model)).riding = entity.func_184218_aH();
        ((NeoEntityModel)((Object)this.model)).young = entity.func_70631_g_();
        float bodyYRot = MathHelper.func_219805_h((float)partialTicks, (float)((LivingEntity)entity).field_70760_ar, (float)((LivingEntity)entity).field_70761_aq);
        float headYRot = MathHelper.func_219805_h((float)partialTicks, (float)((LivingEntity)entity).field_70758_at, (float)((LivingEntity)entity).field_70759_as);
        float netHeadYaw = headYRot - bodyYRot;
        if (entity.func_184218_aH() && entity.func_184187_bx() instanceof LivingEntity) {
            LivingEntity vehicle = (LivingEntity)entity.func_184187_bx();
            bodyYRot = MathHelper.func_219805_h((float)partialTicks, (float)vehicle.field_70760_ar, (float)vehicle.field_70761_aq);
            netHeadYaw = headYRot - bodyYRot;
            ageInTicks = MathHelper.func_76142_g((float)netHeadYaw);
            if (ageInTicks < -85.0f) {
                ageInTicks = -85.0f;
            }
            if (ageInTicks >= 85.0f) {
                ageInTicks = 85.0f;
            }
            bodyYRot = headYRot - ageInTicks;
            if (ageInTicks * ageInTicks > 2500.0f) {
                bodyYRot += ageInTicks * 0.2f;
            }
            netHeadYaw = headYRot - bodyYRot;
        }
        float headPitch = MathHelper.func_219799_g((float)partialTicks, (float)((LivingEntity)entity).field_70127_C, (float)((LivingEntity)entity).field_70125_A);
        if (entity.func_213283_Z() == Pose.SLEEPING && (direction = entity.func_213376_dz()) != null) {
            float eyeHeight = entity.func_213307_e(Pose.STANDING) - 0.1f;
            stack.func_227861_a_((double)((float)(-direction.func_82601_c()) * eyeHeight), 0.0, (double)((float)(-direction.func_82599_e()) * eyeHeight));
        }
        ageInTicks = this.getBob(entity, partialTicks);
        this.setupRotations(entity, stack, ageInTicks, bodyYRot, partialTicks);
        stack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        this.scale(entity, stack, partialTicks);
        stack.func_227861_a_(0.0, (double)-1.501f, 0.0);
        float walkAnimationSpeed = 0.0f;
        float walkAnimationPos = 0.0f;
        if (!entity.func_184218_aH() && entity.func_70089_S()) {
            walkAnimationSpeed = MathHelper.func_219799_g((float)partialTicks, (float)((LivingEntity)entity).field_184618_aE, (float)((LivingEntity)entity).field_70721_aZ);
            walkAnimationPos = ((LivingEntity)entity).field_184619_aG - ((LivingEntity)entity).field_70721_aZ * (1.0f - partialTicks);
            if (entity.func_70631_g_()) {
                walkAnimationPos *= 3.0f;
            }
            if (walkAnimationSpeed > 1.0f) {
                walkAnimationSpeed = 1.0f;
            }
        }
        ((NeoEntityModel)((Object)this.model)).prepareMobModel(entity, walkAnimationPos, walkAnimationSpeed, partialTicks);
        ((NeoEntityModel)((Object)this.model)).setupAnim(entity, walkAnimationPos, walkAnimationSpeed, ageInTicks, netHeadYaw, headPitch);
        Minecraft minecraft = Minecraft.func_71410_x();
        boolean bodyVisible = this.isBodyVisible(entity);
        boolean visibleToPlayer = !bodyVisible && !entity.func_98034_c((PlayerEntity)minecraft.field_71439_g);
        boolean shouldGlow = minecraft.func_238206_b_(entity);
        RenderType renderType = this.getRenderType(entity, bodyVisible, visibleToPlayer, shouldGlow);
        if (renderType != null) {
            IVertexBuilder vertex = buffer.getBuffer(renderType);
            int packedOverlay = NeoLivingEntityRenderer.getOverlayCoords(entity, this.getWhiteOverlayProgress(entity, partialTicks));
            ((NeoEntityModel)((Object)this.model)).func_225598_a_(stack, vertex, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, visibleToPlayer ? 0.15f : 1.0f);
        }
        if (!entity.func_175149_v()) {
            for (NeoRenderLayer<T, M> layer : this.layers) {
                layer.render(stack, buffer, packedLight, entity, walkAnimationPos, walkAnimationSpeed, partialTicks, ageInTicks, netHeadYaw, headPitch);
            }
        }
        stack.func_227865_b_();
        super.func_225623_a_(entity, entityYaw, partialTicks, stack, buffer, packedLight);
    }

    @Nullable
    protected RenderType getRenderType(T entity, boolean isBodyVisible, boolean isVisibleToPlayer, boolean shouldGlow) {
        ResourceLocation texture = this.func_110775_a((Entity)entity);
        if (isVisibleToPlayer) {
            return RenderType.func_239268_f_((ResourceLocation)texture);
        }
        if (isBodyVisible) {
            return this.model.func_228282_a_(texture);
        }
        return shouldGlow ? RenderType.func_228654_j_((ResourceLocation)texture) : null;
    }

    public static int getOverlayCoords(LivingEntity entity, float progress) {
        return OverlayTexture.func_229201_a_((int)OverlayTexture.func_229199_a_((float)progress), (int)OverlayTexture.func_229202_a_((entity.field_70737_aN > 0 || entity.field_70725_aQ > 0 ? 1 : 0) != 0));
    }

    protected boolean isBodyVisible(T livingEntity) {
        return !livingEntity.func_82150_aj();
    }

    private static float sleepDirectionToRotation(Direction direction) {
        switch (direction) {
            case SOUTH: {
                return 90.0f;
            }
            case NORTH: {
                return 270.0f;
            }
            case EAST: {
                return 180.0f;
            }
        }
        return 0.0f;
    }

    protected boolean isShaking(T entity) {
        return false;
    }

    protected void setupRotations(T entity, MatrixStack stack, float ageInTicks, float rotationYaw, float partialTicks) {
        String name;
        Pose pose;
        if (this.isShaking(entity)) {
            rotationYaw += (float)(Math.cos((double)((LivingEntity)entity).field_70173_aa * 3.25) * Math.PI * (double)0.4f);
        }
        if ((pose = entity.func_213283_Z()) != Pose.SLEEPING) {
            stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - rotationYaw));
        }
        if (((LivingEntity)entity).field_70725_aQ > 0) {
            float deathAnimationProgress = ((float)((LivingEntity)entity).field_70725_aQ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((deathAnimationProgress = MathHelper.func_76129_c((float)deathAnimationProgress)) > 1.0f) {
                deathAnimationProgress = 1.0f;
            }
            stack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(deathAnimationProgress * this.getFlipDegrees(entity)));
        } else if (entity.func_204805_cN()) {
            stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f - ((LivingEntity)entity).field_70125_A));
            stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(((float)((LivingEntity)entity).field_70173_aa + partialTicks) * -75.0f));
        } else if (pose == Pose.SLEEPING) {
            Direction bedOrientation = entity.func_213376_dz();
            float rotation = bedOrientation != null ? NeoLivingEntityRenderer.sleepDirectionToRotation(bedOrientation) : rotationYaw;
            stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
            stack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(this.getFlipDegrees(entity)));
            stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(270.0f));
        } else if ((entity.func_145818_k_() || entity instanceof PlayerEntity) && ("Dinnerbone".equals(name = TextFormatting.func_110646_a((String)entity.func_200200_C_().getString())) || "Grumm".equals(name)) && (!(entity instanceof PlayerEntity) || ((PlayerEntity)entity).func_175148_a(PlayerModelPart.CAPE))) {
            stack.func_227861_a_(0.0, (double)(entity.func_213302_cg() + 0.1f), 0.0);
            stack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        }
    }

    protected float getAttackAnim(T entity, float partialTick) {
        return entity.func_70678_g(partialTick);
    }

    protected float getBob(T entity, float partialTick) {
        return (float)((LivingEntity)entity).field_70173_aa + partialTick;
    }

    protected float getFlipDegrees(T entity) {
        return 90.0f;
    }

    protected float getWhiteOverlayProgress(T entity, float partialTick) {
        return 0.0f;
    }

    protected void scale(T entity, MatrixStack stack, float partialTick) {
    }

    protected boolean shouldShowName(T entity) {
        boolean isVisibleToPlayer;
        float range;
        double distance = this.field_76990_c.func_229099_b_(entity);
        float f = range = entity.func_226273_bm_() ? 32.0f : 64.0f;
        if (distance >= (double)(range * range)) {
            return false;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        ClientPlayerEntity player = minecraft.field_71439_g;
        boolean bl = isVisibleToPlayer = !entity.func_98034_c((PlayerEntity)player);
        if (entity != player) {
            Team entityTeam = entity.func_96124_cp();
            Team playerTeam = player.func_96124_cp();
            if (entityTeam != null) {
                Team.Visible visibility = entityTeam.func_178770_i();
                switch (visibility) {
                    case ALWAYS: {
                        return isVisibleToPlayer;
                    }
                    case NEVER: {
                        return false;
                    }
                    case HIDE_FOR_OTHER_TEAMS: {
                        return playerTeam == null ? isVisibleToPlayer : entityTeam.func_142054_a(playerTeam) && (entityTeam.func_98297_h() || isVisibleToPlayer);
                    }
                    case HIDE_FOR_OWN_TEAM: {
                        return playerTeam == null ? isVisibleToPlayer : !entityTeam.func_142054_a(playerTeam) && isVisibleToPlayer;
                    }
                }
                return true;
            }
        }
        return Minecraft.func_71382_s() && entity != minecraft.func_175606_aa() && isVisibleToPlayer && !entity.func_184207_aI();
    }
}

