/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.client.renderer;

import com.blackgear.platform.client.renderer.NeoLivingEntityRenderer;
import com.blackgear.platform.client.renderer.model.NeoEntityModel;
import com.blackgear.platform.core.mixin.access.EntityRendererAccessor;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.LightType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class NeoMobRenderer<T extends MobEntity, M extends NeoEntityModel<T>>
extends NeoLivingEntityRenderer<T, M> {
    public NeoMobRenderer(EntityRendererManager dispatcher, M model, float shadowRadius) {
        super(dispatcher, model, shadowRadius);
    }

    @Override
    protected boolean shouldShowName(T entity) {
        return super.shouldShowName(entity) && (entity.func_94059_bO() || entity.func_145818_k_() && entity == this.field_76990_c.field_147941_i);
    }

    public boolean shouldRender(T mob, ClippingHelper frustum, double camX, double camY, double camZ) {
        if (super.func_225626_a_(mob, frustum, camX, camY, camZ)) {
            return true;
        }
        Entity entity = mob.func_110166_bE();
        return entity != null && frustum.func_228957_a_(entity.func_184177_bl());
    }

    @Override
    public void render(T entity, float entityYaw, float partialTicks, MatrixStack stack, IRenderTypeBuffer buffer, int packedLight) {
        super.render(entity, entityYaw, partialTicks, stack, buffer, packedLight);
        Entity leashHolder = entity.func_110166_bE();
        if (leashHolder != null) {
            this.renderLeashLegacy(entity, partialTicks, stack, buffer, leashHolder);
        }
    }

    private <E extends Entity> void renderLeash(T entity, float partialTicks, MatrixStack stack, IRenderTypeBuffer buffer, E leashHolder) {
        int segments;
        stack.func_227860_a_();
        Vector3d ropeHoldPosition = leashHolder.func_241843_o(partialTicks);
        double bodyRotation = (double)(MathHelper.func_219799_g((float)partialTicks, (float)((MobEntity)entity).field_70761_aq, (float)((MobEntity)entity).field_70760_ar) * ((float)Math.PI / 180)) + 1.5707963267948966;
        Vector3d leashOffset = entity.func_241205_ce_();
        double leashOffsetX = Math.cos(bodyRotation) * leashOffset.field_72449_c + Math.sin(bodyRotation) * leashOffset.field_72450_a;
        double leashOffsetZ = Math.sin(bodyRotation) * leashOffset.field_72449_c - Math.cos(bodyRotation) * leashOffset.field_72450_a;
        double entityX = MathHelper.func_219803_d((double)partialTicks, (double)((MobEntity)entity).field_70169_q, (double)entity.func_226277_ct_()) + leashOffsetX;
        double entityY = MathHelper.func_219803_d((double)partialTicks, (double)((MobEntity)entity).field_70167_r, (double)entity.func_226278_cu_()) + leashOffset.field_72448_b;
        double entityZ = MathHelper.func_219803_d((double)partialTicks, (double)((MobEntity)entity).field_70166_s, (double)entity.func_226281_cx_()) + leashOffsetZ;
        stack.func_227861_a_(leashOffsetX, leashOffset.field_72448_b, leashOffsetZ);
        float deltaX = (float)(ropeHoldPosition.field_72450_a - entityX);
        float deltaY = (float)(ropeHoldPosition.field_72448_b - entityY);
        float deltaZ = (float)(ropeHoldPosition.field_72449_c - entityZ);
        IVertexBuilder vertex = buffer.getBuffer(RenderType.func_228649_h_());
        Matrix4f matrix = stack.func_227866_c_().func_227870_a_();
        float radius = MathHelper.func_226165_i_((float)(deltaX * deltaX + deltaZ * deltaZ)) * 0.025f / 2.0f;
        float xOffset = deltaZ * radius;
        float zOffset = deltaX * radius;
        BlockPos entityPosition = new BlockPos(entity.func_174824_e(partialTicks));
        BlockPos leashHolderPosition = new BlockPos(leashHolder.func_174824_e(partialTicks));
        int entityBlockLight = this.func_225624_a_((Entity)entity, entityPosition);
        int leashHolderBlockLight = ((EntityRendererAccessor)this.field_76990_c.func_78713_a(leashHolder)).callGetBlockLightLevel(leashHolder, leashHolderPosition);
        int entitySkyLight = ((MobEntity)entity).field_70170_p.func_226658_a_(LightType.SKY, entityPosition);
        int leashHolderSkyLight = ((MobEntity)entity).field_70170_p.func_226658_a_(LightType.SKY, leashHolderPosition);
        for (segments = 0; segments <= 24; ++segments) {
            NeoMobRenderer.addVertexPair(vertex, matrix, deltaX, deltaY, deltaZ, entityBlockLight, leashHolderBlockLight, entitySkyLight, leashHolderSkyLight, 0.025f, 0.025f, xOffset, zOffset, segments, false);
        }
        for (segments = 24; segments >= 0; --segments) {
            NeoMobRenderer.addVertexPair(vertex, matrix, deltaX, deltaY, deltaZ, entityBlockLight, leashHolderBlockLight, entitySkyLight, leashHolderSkyLight, 0.025f, 0.0f, xOffset, zOffset, segments, true);
        }
        stack.func_227865_b_();
    }

    private static void addVertexPair(IVertexBuilder vertex, Matrix4f matrix, float deltaX, float deltaY, float deltaZ, int entityBlockLight, int leashHolderBlockLight, int entitySkyLight, int leashHolderSkyLight, float leashThickness, float leashOffset, float xOffset, float zOffset, int index, boolean oddSegment) {
        float segmentRatio = (float)index / 24.0f;
        int blockLight = (int)MathHelper.func_219799_g((float)segmentRatio, (float)entityBlockLight, (float)leashHolderBlockLight);
        int skyLight = (int)MathHelper.func_219799_g((float)segmentRatio, (float)entitySkyLight, (float)leashHolderSkyLight);
        int lightMapUV = LightTexture.func_228451_a_((int)blockLight, (int)skyLight);
        float brightnessFactor = index % 2 == (oddSegment ? 1 : 0) ? 0.7f : 1.0f;
        float red = 0.5f * brightnessFactor;
        float green = 0.4f * brightnessFactor;
        float blue = 0.3f * brightnessFactor;
        float factorX = deltaX * segmentRatio;
        float factorY = deltaY > 0.0f ? deltaY * segmentRatio * segmentRatio : deltaY - deltaY * (1.0f - segmentRatio) * (1.0f - segmentRatio);
        float factorZ = deltaZ * segmentRatio;
        vertex.func_227888_a_(matrix, factorX - xOffset, factorY + leashOffset, factorZ + zOffset).func_227885_a_(red, green, blue, 1.0f).func_227886_a_(lightMapUV).func_181675_d();
        vertex.func_227888_a_(matrix, factorX + xOffset, factorY + leashThickness - leashOffset, factorZ - zOffset).func_227885_a_(red, green, blue, 1.0f).func_227886_a_(lightMapUV).func_181675_d();
    }

    private <E extends Entity> void renderLeashLegacy(T entityLiving, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, E leashHolder) {
        matrixStack.func_227860_a_();
        Vector3d vec3 = leashHolder.func_241843_o(partialTicks);
        double d = (double)(MathHelper.func_219799_g((float)partialTicks, (float)((MobEntity)entityLiving).field_70761_aq, (float)((MobEntity)entityLiving).field_70760_ar) * ((float)Math.PI / 180)) + 1.5707963267948966;
        Vector3d vec32 = entityLiving.func_241205_ce_();
        double e = Math.cos(d) * vec32.field_72449_c + Math.sin(d) * vec32.field_72450_a;
        double f = Math.sin(d) * vec32.field_72449_c - Math.cos(d) * vec32.field_72450_a;
        double g = MathHelper.func_219803_d((double)partialTicks, (double)((MobEntity)entityLiving).field_70169_q, (double)entityLiving.func_226277_ct_()) + e;
        double h = MathHelper.func_219803_d((double)partialTicks, (double)((MobEntity)entityLiving).field_70167_r, (double)entityLiving.func_226278_cu_()) + vec32.field_72448_b;
        double i = MathHelper.func_219803_d((double)partialTicks, (double)((MobEntity)entityLiving).field_70166_s, (double)entityLiving.func_226281_cx_()) + f;
        matrixStack.func_227861_a_(e, vec32.field_72448_b, f);
        float j = (float)(vec3.field_72450_a - g);
        float k = (float)(vec3.field_72448_b - h);
        float l = (float)(vec3.field_72449_c - i);
        float m = 0.025f;
        IVertexBuilder vertexConsumer = buffer.getBuffer(RenderType.func_228649_h_());
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        float n = MathHelper.func_226165_i_((float)(j * j + l * l)) * 0.025f / 2.0f;
        float o = l * n;
        float p = j * n;
        BlockPos blockPos = new BlockPos(entityLiving.func_174824_e(partialTicks));
        BlockPos blockPos2 = new BlockPos(leashHolder.func_174824_e(partialTicks));
        int q = this.func_225624_a_((Entity)entityLiving, blockPos);
        int r = ((EntityRendererAccessor)this.field_76990_c.func_78713_a(leashHolder)).callGetBlockLightLevel(leashHolder, blockPos2);
        int s = ((MobEntity)entityLiving).field_70170_p.func_226658_a_(LightType.SKY, blockPos);
        int t = ((MobEntity)entityLiving).field_70170_p.func_226658_a_(LightType.SKY, blockPos2);
        NeoMobRenderer.renderSide(vertexConsumer, matrix4f, j, k, l, q, r, s, t, 0.025f, 0.025f, o, p);
        NeoMobRenderer.renderSide(vertexConsumer, matrix4f, j, k, l, q, r, s, t, 0.025f, 0.0f, o, p);
        matrixStack.func_227865_b_();
    }

    public static void renderSide(IVertexBuilder vertexConsumer, Matrix4f matrix4f, float f, float g, float h, int i, int j, int k, int l, float m, float n, float o, float p) {
        for (int r = 0; r < 24; ++r) {
            float s = (float)r / 23.0f;
            int t = (int)MathHelper.func_219799_g((float)s, (float)i, (float)j);
            int u = (int)MathHelper.func_219799_g((float)s, (float)k, (float)l);
            int v = LightTexture.func_228451_a_((int)t, (int)u);
            NeoMobRenderer.addVertexPair(vertexConsumer, matrix4f, v, f, g, h, m, n, 24, r, false, o, p);
            NeoMobRenderer.addVertexPair(vertexConsumer, matrix4f, v, f, g, h, m, n, 24, r + 1, true, o, p);
        }
    }

    public static void addVertexPair(IVertexBuilder vertexConsumer, Matrix4f matrix4f, int i, float f, float g, float h, float j, float k, int l, int m, boolean bl, float n, float o) {
        float p = 0.5f;
        float q = 0.4f;
        float r = 0.3f;
        if (m % 2 == 0) {
            p *= 0.7f;
            q *= 0.7f;
            r *= 0.7f;
        }
        float s = (float)m / (float)l;
        float t = f * s;
        float u = g > 0.0f ? g * s * s : g - g * (1.0f - s) * (1.0f - s);
        float v = h * s;
        if (!bl) {
            vertexConsumer.func_227888_a_(matrix4f, t + n, u + j - k, v - o).func_227885_a_(p, q, r, 1.0f).func_227886_a_(i).func_181675_d();
        }
        vertexConsumer.func_227888_a_(matrix4f, t - n, u + k, v + o).func_227885_a_(p, q, r, 1.0f).func_227886_a_(i).func_181675_d();
        if (bl) {
            vertexConsumer.func_227888_a_(matrix4f, t + n, u + j - k, v - o).func_227885_a_(p, q, r, 1.0f).func_227886_a_(i).func_181675_d();
        }
    }
}

