/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.client.renderer.model;

import com.blackgear.platform.client.renderer.model.NeoHierarchicalModel;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class NeoAgeableHierarchicalModel<E extends Entity>
extends NeoHierarchicalModel<E> {
    private final float youngScaleFactor;
    private final float bodyYOffset;

    public NeoAgeableHierarchicalModel(float youngScaleFactor, float bodyYOffset) {
        this(youngScaleFactor, bodyYOffset, RenderType::func_228640_c_);
    }

    public NeoAgeableHierarchicalModel(float youngScaleFactor, float bodyYOffset, Function<ResourceLocation, RenderType> factory) {
        super(factory);
        this.youngScaleFactor = youngScaleFactor;
        this.bodyYOffset = bodyYOffset;
    }

    @Override
    public void renderToBuffer(MatrixStack stack, IVertexBuilder buffer, int packedLight, int packedOverlay, int color) {
        if (this.young) {
            stack.func_227860_a_();
            stack.func_227862_a_(this.youngScaleFactor, this.youngScaleFactor, this.youngScaleFactor);
            stack.func_227861_a_(0.0, (double)(this.bodyYOffset / 16.0f), 0.0);
            this.root().render(stack, buffer, packedLight, packedOverlay, color);
            stack.func_227865_b_();
        } else {
            this.root().render(stack, buffer, packedLight, packedOverlay, color);
        }
    }
}

