/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.client.renderer.model;

import com.blackgear.platform.client.renderer.model.NeoEntityModel;
import com.blackgear.platform.client.renderer.model.geom.NeoModelPart;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class NeoAgeableListModel<E extends Entity>
extends NeoEntityModel<E> {
    private final boolean scaleHead;
    private final float babyYHeadOffset;
    private final float babyZHeadOffset;
    private final float babyHeadScale;
    private final float babyBodyScale;
    private final float bodyYOffset;

    protected NeoAgeableListModel(boolean scaleHead, float babyYHeadOffset, float babyZHeadOffset) {
        this(scaleHead, babyYHeadOffset, babyZHeadOffset, 2.0f, 2.0f, 24.0f);
    }

    protected NeoAgeableListModel(boolean scaleHead, float babyYHeadOffset, float babyZHeadOffset, float babyHeadScale, float babyBodyScale, float bodyYOffset) {
        this(RenderType::func_228640_c_, scaleHead, babyYHeadOffset, babyZHeadOffset, babyHeadScale, babyBodyScale, bodyYOffset);
    }

    protected NeoAgeableListModel(Function<ResourceLocation, RenderType> factory, boolean scaleHead, float babyYHeadOffset, float babyZHeadOffset, float babyHeadScale, float babyBodyScale, float bodyYOffset) {
        super(factory);
        this.scaleHead = scaleHead;
        this.babyYHeadOffset = babyYHeadOffset;
        this.babyZHeadOffset = babyZHeadOffset;
        this.babyHeadScale = babyHeadScale;
        this.babyBodyScale = babyBodyScale;
        this.bodyYOffset = bodyYOffset;
    }

    protected NeoAgeableListModel() {
        this(false, 5.0f, 2.0f);
    }

    @Override
    public void renderToBuffer(MatrixStack stack, IVertexBuilder buffer, int packedLight, int packedOverlay, int color) {
        if (this.young) {
            stack.func_227860_a_();
            if (this.scaleHead) {
                float headScale = 1.5f / this.babyHeadScale;
                stack.func_227862_a_(headScale, headScale, headScale);
            }
            stack.func_227861_a_(0.0, (double)(this.babyYHeadOffset / 16.0f), (double)(this.babyZHeadOffset / 16.0f));
            this.headParts().forEach(modelPart -> modelPart.render(stack, buffer, packedLight, packedOverlay, color));
            stack.func_227865_b_();
            stack.func_227860_a_();
            float bodyScale = 1.0f / this.babyBodyScale;
            stack.func_227862_a_(bodyScale, bodyScale, bodyScale);
            stack.func_227861_a_(0.0, (double)(this.bodyYOffset / 16.0f), 0.0);
            this.bodyParts().forEach(modelPart -> modelPart.render(stack, buffer, packedLight, packedOverlay, color));
            stack.func_227865_b_();
        } else {
            this.headParts().forEach(modelPart -> modelPart.render(stack, buffer, packedLight, packedOverlay, color));
            this.bodyParts().forEach(modelPart -> modelPart.render(stack, buffer, packedLight, packedOverlay, color));
        }
    }

    protected abstract Iterable<NeoModelPart> headParts();

    protected abstract Iterable<NeoModelPart> bodyParts();
}

