/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.client.renderer.model;

import com.blackgear.platform.client.renderer.model.NeoAgeableListModel;
import com.blackgear.platform.client.renderer.model.geom.NeoModelPart;
import com.blackgear.platform.client.renderer.model.geom.PartPose;
import com.blackgear.platform.client.renderer.model.geom.builder.CubeDeformation;
import com.blackgear.platform.client.renderer.model.geom.builder.CubeListBuilder;
import com.blackgear.platform.client.renderer.model.geom.builder.MeshDefinition;
import com.blackgear.platform.client.renderer.model.geom.builder.PartDefinition;
import com.google.common.collect.ImmutableList;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NeoQuadrupedModel<T extends Entity>
extends NeoAgeableListModel<T> {
    protected final NeoModelPart head;
    protected final NeoModelPart body;
    protected final NeoModelPart rightHindLeg;
    protected final NeoModelPart leftHindLeg;
    protected final NeoModelPart rightFrontLeg;
    protected final NeoModelPart leftFrontLeg;

    protected NeoQuadrupedModel(NeoModelPart root, boolean scaleHead, float babyYHeadOffset, float babyZHeadOffset, float babyHeadScale, float babyBodyScale, int bodyYOffset) {
        super(scaleHead, babyYHeadOffset, babyZHeadOffset, babyHeadScale, babyBodyScale, bodyYOffset);
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.rightHindLeg = root.getChild("right_hind_leg");
        this.leftHindLeg = root.getChild("left_hind_leg");
        this.rightFrontLeg = root.getChild("right_front_leg");
        this.leftFrontLeg = root.getChild("left_front_leg");
    }

    public static MeshDefinition createBodyMesh(int i, CubeDeformation deformation) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -8.0f, 8.0f, 8.0f, 8.0f, deformation), PartPose.offset(0.0f, 18 - i, -6.0f));
        root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(28, 8).addBox(-5.0f, -10.0f, -7.0f, 10.0f, 16.0f, 8.0f, deformation), PartPose.offsetAndRotation(0.0f, 17 - i, 2.0f, 1.5707964f, 0.0f, 0.0f));
        CubeListBuilder leg = CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, (float)i, 4.0f, deformation);
        root.addOrReplaceChild("right_hind_leg", leg, PartPose.offset(-3.0f, 24 - i, 7.0f));
        root.addOrReplaceChild("left_hind_leg", leg, PartPose.offset(3.0f, 24 - i, 7.0f));
        root.addOrReplaceChild("right_front_leg", leg, PartPose.offset(-3.0f, 24 - i, -5.0f));
        root.addOrReplaceChild("left_front_leg", leg, PartPose.offset(3.0f, 24 - i, -5.0f));
        return mesh;
    }

    @Override
    protected Iterable<NeoModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    @Override
    protected Iterable<NeoModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightHindLeg, (Object)this.leftHindLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg);
    }

    @Override
    public void setupAnim(T entity, float walkAnimationPos, float walkAnimationSpeed, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.rightHindLeg.xRot = MathHelper.func_76134_b((float)(walkAnimationPos * 0.6662f)) * 1.4f * walkAnimationSpeed;
        this.leftHindLeg.xRot = MathHelper.func_76134_b((float)(walkAnimationPos * 0.6662f + (float)Math.PI)) * 1.4f * walkAnimationSpeed;
        this.rightFrontLeg.xRot = MathHelper.func_76134_b((float)(walkAnimationPos * 0.6662f + (float)Math.PI)) * 1.4f * walkAnimationSpeed;
        this.leftFrontLeg.xRot = MathHelper.func_76134_b((float)(walkAnimationPos * 0.6662f)) * 1.4f * walkAnimationSpeed;
    }
}

