/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.client.renderer.model.animation;

import com.blackgear.platform.client.renderer.model.animation.Keyframe;
import com.blackgear.platform.client.renderer.model.geom.NeoModelPart;
import com.blackgear.platform.core.util.MathUtils;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AnimationChannel {
    private final Target target;
    private final Keyframe[] keyframes;

    public AnimationChannel(Target target, Keyframe ... keyframes) {
        this.target = target;
        this.keyframes = keyframes;
    }

    public Target target() {
        return this.target;
    }

    public Keyframe[] keyframes() {
        return this.keyframes;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface Target {
        public void apply(NeoModelPart var1, Vector3f var2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface Interpolation {
        public Vector3f apply(Vector3f var1, float var2, Keyframe[] var3, int var4, int var5, float var6);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Targets {
        public static final Target POSITION = NeoModelPart::offsetPos;
        public static final Target ROTATION = NeoModelPart::offsetRotation;
        public static final Target SCALE = NeoModelPart::offsetScale;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Interpolations {
        public static final Interpolation LINEAR = (cache, delta, keyframes, start, end, speed) -> {
            Vector3f frameStart = keyframes[start].target();
            Vector3f frameEnd = keyframes[end].target();
            cache.func_195905_a(MathHelper.func_219799_g((float)delta, (float)frameStart.func_195899_a(), (float)frameEnd.func_195899_a()) * speed, MathHelper.func_219799_g((float)delta, (float)frameStart.func_195900_b(), (float)frameEnd.func_195900_b()) * speed, MathHelper.func_219799_g((float)delta, (float)frameStart.func_195902_c(), (float)frameEnd.func_195902_c()) * speed);
            return cache;
        };
        public static final Interpolation CATMULLROM = (cache, delta, keyframes, start, end, speed) -> {
            Vector3f frameStartPoint = keyframes[Math.max(0, start - 1)].target();
            Vector3f frameStart = keyframes[start].target();
            Vector3f frameEnd = keyframes[end].target();
            Vector3f frameEndPoint = keyframes[Math.min(keyframes.length - 1, end + 1)].target();
            cache.func_195905_a(MathUtils.catmullrom(delta, frameStartPoint.func_195899_a(), frameStart.func_195899_a(), frameEnd.func_195899_a(), frameEndPoint.func_195899_a()) * speed, MathUtils.catmullrom(delta, frameStartPoint.func_195900_b(), frameStart.func_195900_b(), frameEnd.func_195900_b(), frameEndPoint.func_195900_b()) * speed, MathUtils.catmullrom(delta, frameStartPoint.func_195902_c(), frameStart.func_195902_c(), frameEnd.func_195902_c(), frameEndPoint.func_195902_c()) * speed);
            return cache;
        };
    }
}

