/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.client.renderer.model.geom;

import com.blackgear.platform.client.renderer.model.geom.ModelLayerLocation;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelLayers {
    private static final String DEFAULT_LAYER = "main";
    public static final Set<ModelLayerLocation> ALL_MODELS = Sets.newHashSet();

    public static ModelLayerLocation register(ResourceLocation model) {
        return ModelLayers.register(model, DEFAULT_LAYER);
    }

    public static ModelLayerLocation register(ResourceLocation model, String layer) {
        ModelLayerLocation location = new ModelLayerLocation(model, layer);
        if (!ALL_MODELS.add(location)) {
            throw new IllegalStateException("Duplicate registration for " + location);
        }
        return location;
    }

    public static Stream<ModelLayerLocation> getKnownLocations() {
        return ALL_MODELS.stream();
    }
}

