/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.client.renderer.model.geom;

import com.blackgear.platform.client.renderer.model.geom.PartPose;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NeoModelPart {
    public float x;
    public float y;
    public float z;
    public float xRot;
    public float yRot;
    public float zRot;
    public float xScale = 1.0f;
    public float yScale = 1.0f;
    public float zScale = 1.0f;
    public boolean visible = true;
    public boolean skipDraw;
    private final List<Cube> cubes;
    private final Map<String, NeoModelPart> children;
    private PartPose initialPose = PartPose.ZERO;

    public NeoModelPart(List<Cube> cubes, Map<String, NeoModelPart> children) {
        this.cubes = cubes;
        this.children = children;
    }

    public PartPose storePose() {
        return PartPose.offsetAndRotation(this.x, this.y, this.z, this.xRot, this.yRot, this.zRot);
    }

    public PartPose getInitialPose() {
        return this.initialPose;
    }

    public void setInitialPose(PartPose part) {
        this.initialPose = part;
    }

    public void resetPose() {
        this.loadPose(this.initialPose);
    }

    public void loadPose(PartPose part) {
        this.x = part.x;
        this.y = part.y;
        this.z = part.z;
        this.xRot = part.xRot;
        this.yRot = part.yRot;
        this.zRot = part.zRot;
        this.xScale = 1.0f;
        this.yScale = 1.0f;
        this.zScale = 1.0f;
    }

    public void copyFrom(NeoModelPart part) {
        this.xScale = part.xScale;
        this.yScale = part.yScale;
        this.zScale = part.zScale;
        this.xRot = part.xRot;
        this.yRot = part.yRot;
        this.zRot = part.zRot;
        this.x = part.x;
        this.y = part.y;
        this.z = part.z;
    }

    public boolean hasChild(String partName) {
        return this.children.containsKey(partName);
    }

    public NeoModelPart getChild(String partName) {
        NeoModelPart part = this.children.get(partName);
        if (part == null) {
            throw new NoSuchElementException("Can't find part " + partName);
        }
        return part;
    }

    public void setPos(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void setRotation(float xRot, float yRot, float zRot) {
        this.xRot = xRot;
        this.yRot = yRot;
        this.zRot = zRot;
    }

    public void render(MatrixStack stack, IVertexBuilder vertices, int packedLight, int packedOverlay) {
        this.render(stack, vertices, packedLight, packedOverlay, -1);
    }

    public void render(MatrixStack stack, IVertexBuilder vertices, int packedLight, int packedOverlay, int color) {
        if (!(!this.visible || this.cubes.isEmpty() && this.children.isEmpty())) {
            stack.func_227860_a_();
            this.translateAndRotate(stack);
            if (!this.skipDraw) {
                this.compile(stack.func_227866_c_(), vertices, packedLight, packedOverlay, color);
            }
            for (NeoModelPart part : this.children.values()) {
                part.render(stack, vertices, packedLight, packedOverlay, color);
            }
            stack.func_227865_b_();
        }
    }

    public void visit(MatrixStack stack, Visitor visitor) {
        this.visit(stack, visitor, "");
    }

    private void visit(MatrixStack stack, Visitor visitor, String partName) {
        if (!this.cubes.isEmpty() || !this.children.isEmpty()) {
            stack.func_227860_a_();
            this.translateAndRotate(stack);
            MatrixStack.Entry pose = stack.func_227866_c_();
            for (int i = 0; i < this.cubes.size(); ++i) {
                visitor.visit(pose, partName, i, this.cubes.get(i));
            }
            String location = partName + "/";
            this.children.forEach((children, part) -> part.visit(stack, visitor, location + children));
            stack.func_227865_b_();
        }
    }

    public void translateAndRotate(MatrixStack stack) {
        stack.func_227861_a_((double)(this.x / 16.0f), (double)(this.y / 16.0f), (double)(this.z / 16.0f));
        if (this.zRot != 0.0f) {
            stack.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(this.zRot));
        }
        if (this.yRot != 0.0f) {
            stack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(this.yRot));
        }
        if (this.xRot != 0.0f) {
            stack.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(this.xRot));
        }
        if (this.xScale != 1.0f || this.yScale != 1.0f || this.zScale != 1.0f) {
            stack.func_227862_a_(this.xScale, this.yScale, this.zScale);
        }
    }

    private void compile(MatrixStack.Entry pose, IVertexBuilder vertices, int packedLight, int packedOverlay, int color) {
        for (Cube cube : this.cubes) {
            cube.compile(pose, vertices, packedLight, packedOverlay, color);
        }
    }

    public Cube getRandomCube(Random random) {
        return this.cubes.get(random.nextInt(this.cubes.size()));
    }

    public boolean isEmpty() {
        return this.cubes.isEmpty();
    }

    public void offsetPos(Vector3f vector) {
        this.x += vector.func_195899_a();
        this.y += vector.func_195900_b();
        this.z += vector.func_195902_c();
    }

    public void offsetRotation(Vector3f vector) {
        this.xRot += vector.func_195899_a();
        this.yRot += vector.func_195900_b();
        this.zRot += vector.func_195902_c();
    }

    public void offsetScale(Vector3f vector) {
        this.xScale += vector.func_195899_a();
        this.yScale += vector.func_195900_b();
        this.zScale += vector.func_195902_c();
    }

    public Stream<NeoModelPart> getAllParts() {
        return Stream.concat(Stream.of(this), this.children.values().stream().flatMap(NeoModelPart::getAllParts));
    }

    @FunctionalInterface
    @OnlyIn(value=Dist.CLIENT)
    public static interface Visitor {
        public void visit(MatrixStack.Entry var1, String var2, int var3, Cube var4);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Cube {
        private final Polygon[] polygons;
        public final float minX;
        public final float minY;
        public final float minZ;
        public final float maxX;
        public final float maxY;
        public final float maxZ;

        public Cube(int texCoordU, int texCoordV, float originX, float originY, float originZ, float dimensionsX, float dimensionsY, float dimensionsZ, float growX, float growY, float growZ, boolean mirror, float texScaleU, float texScaleV, Set<Direction> visibleFaces) {
            this.minX = originX;
            this.minY = originY;
            this.minZ = originZ;
            this.maxX = originX + dimensionsX;
            this.maxY = originY + dimensionsY;
            this.maxZ = originZ + dimensionsZ;
            this.polygons = new Polygon[visibleFaces.size()];
            float maxX = originX + dimensionsX;
            float maxY = originY + dimensionsY;
            float maxZ = originZ + dimensionsZ;
            originX -= growX;
            originY -= growY;
            originZ -= growZ;
            maxX += growX;
            maxY += growY;
            maxZ += growZ;
            if (mirror) {
                float offset = maxX;
                maxX = originX;
                originX = offset;
            }
            Vertex vertex = new Vertex(originX, originY, originZ, 0.0f, 0.0f);
            Vertex vertex2 = new Vertex(maxX, originY, originZ, 0.0f, 8.0f);
            Vertex vertex3 = new Vertex(maxX, maxY, originZ, 8.0f, 8.0f);
            Vertex vertex4 = new Vertex(originX, maxY, originZ, 8.0f, 0.0f);
            Vertex vertex5 = new Vertex(originX, originY, maxZ, 0.0f, 0.0f);
            Vertex vertex6 = new Vertex(maxX, originY, maxZ, 0.0f, 8.0f);
            Vertex vertex7 = new Vertex(maxX, maxY, maxZ, 8.0f, 8.0f);
            Vertex vertex8 = new Vertex(originX, maxY, maxZ, 8.0f, 0.0f);
            float texU1 = texCoordU;
            float texU2 = (float)texCoordU + dimensionsZ;
            float texU3 = (float)texCoordU + dimensionsZ + dimensionsX;
            float texU4 = (float)texCoordU + dimensionsZ + dimensionsX + dimensionsX;
            float texU5 = (float)texCoordU + dimensionsZ + dimensionsX + dimensionsZ;
            float texU6 = (float)texCoordU + dimensionsZ + dimensionsX + dimensionsZ + dimensionsX;
            float texV1 = texCoordV;
            float texV2 = (float)texCoordV + dimensionsZ;
            float texV3 = (float)texCoordV + dimensionsZ + dimensionsY;
            int index = 0;
            if (visibleFaces.contains(Direction.DOWN)) {
                this.polygons[index++] = new Polygon(new Vertex[]{vertex6, vertex5, vertex, vertex2}, texU2, texV1, texU3, texV2, texScaleU, texScaleV, mirror, Direction.DOWN);
            }
            if (visibleFaces.contains(Direction.UP)) {
                this.polygons[index++] = new Polygon(new Vertex[]{vertex3, vertex4, vertex8, vertex7}, texU3, texV2, texU4, texV1, texScaleU, texScaleV, mirror, Direction.UP);
            }
            if (visibleFaces.contains(Direction.WEST)) {
                this.polygons[index++] = new Polygon(new Vertex[]{vertex, vertex5, vertex8, vertex4}, texU1, texV2, texU2, texV3, texScaleU, texScaleV, mirror, Direction.WEST);
            }
            if (visibleFaces.contains(Direction.NORTH)) {
                this.polygons[index++] = new Polygon(new Vertex[]{vertex2, vertex, vertex4, vertex3}, texU2, texV2, texU3, texV3, texScaleU, texScaleV, mirror, Direction.NORTH);
            }
            if (visibleFaces.contains(Direction.EAST)) {
                this.polygons[index++] = new Polygon(new Vertex[]{vertex6, vertex2, vertex3, vertex7}, texU3, texV2, texU5, texV3, texScaleU, texScaleV, mirror, Direction.EAST);
            }
            if (visibleFaces.contains(Direction.SOUTH)) {
                this.polygons[index] = new Polygon(new Vertex[]{vertex5, vertex6, vertex7, vertex8}, texU5, texV2, texU6, texV3, texScaleU, texScaleV, mirror, Direction.SOUTH);
            }
        }

        public void compile(MatrixStack.Entry pose, IVertexBuilder vertices, int packedLight, int packedOverlay, int color) {
            Matrix4f matrix = pose.func_227870_a_();
            for (Polygon polygon : this.polygons) {
                Vector3f normal = polygon.normal.func_229195_e_();
                normal.func_229188_a_(pose.func_227872_b_());
                float normalX = normal.func_195899_a();
                float normalY = normal.func_195900_b();
                float normalZ = normal.func_195902_c();
                for (Vertex vertex : polygon.vertices) {
                    float x = vertex.pos.func_195899_a() / 16.0f;
                    float y = vertex.pos.func_195900_b() / 16.0f;
                    float z = vertex.pos.func_195902_c() / 16.0f;
                    Vector4f vector = new Vector4f(x, y, z, 1.0f);
                    vector.func_229372_a_(matrix);
                    vertices.func_225588_a_(vector.func_195910_a(), vector.func_195913_b(), vector.func_195914_c(), (float)ColorHelper.PackedColor.func_233007_b_((int)color), (float)ColorHelper.PackedColor.func_233008_c_((int)color), (float)ColorHelper.PackedColor.func_233009_d_((int)color), (float)ColorHelper.PackedColor.func_233004_a_((int)color), vertex.u, vertex.v, packedOverlay, packedLight, normalX, normalY, normalZ);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Vertex {
        public final Vector3f pos;
        public final float u;
        public final float v;

        public Vertex(float x, float y, float z, float u, float v) {
            this(new Vector3f(x, y, z), u, v);
        }

        public Vertex remap(float u, float v) {
            return new Vertex(this.pos, u, v);
        }

        public Vertex(Vector3f pos, float u, float v) {
            this.pos = pos;
            this.u = u;
            this.v = v;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Polygon {
        public final Vertex[] vertices;
        public final Vector3f normal;

        public Polygon(Vertex[] vertices, float u1, float v1, float u2, float v2, float texWidth, float texHeight, boolean mirror, Direction direction) {
            this.vertices = vertices;
            float uOffset = 0.0f / texWidth;
            float vOffset = 0.0f / texHeight;
            vertices[0] = vertices[0].remap(u2 / texWidth - uOffset, v1 / texHeight + vOffset);
            vertices[1] = vertices[1].remap(u1 / texWidth + uOffset, v1 / texHeight + vOffset);
            vertices[2] = vertices[2].remap(u1 / texWidth + uOffset, v2 / texHeight - vOffset);
            vertices[3] = vertices[3].remap(u2 / texWidth - uOffset, v2 / texHeight - vOffset);
            if (mirror) {
                int vertexCount = vertices.length;
                for (int i = 0; i < vertexCount / 2; ++i) {
                    Vertex vertex = vertices[i];
                    vertices[i] = vertices[vertexCount - 1 - i];
                    vertices[vertexCount - 1 - i] = vertex;
                }
            }
            this.normal = direction.func_229386_k_();
            if (mirror) {
                this.normal.func_229192_b_(-1.0f, 1.0f, 1.0f);
            }
        }
    }
}

