/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.client.renderer.model.geom.builder;

import com.blackgear.platform.client.renderer.model.geom.NeoModelPart;
import com.blackgear.platform.client.renderer.model.geom.builder.CubeDeformation;
import com.blackgear.platform.client.renderer.model.geom.builder.UVPair;
import java.util.Set;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public final class CubeDefinition {
    private final Vector3f origin;
    private final Vector3f dimensions;
    private final CubeDeformation grow;
    private final boolean mirror;
    private final UVPair texCoord;
    private final UVPair texScale;
    private final Set<Direction> visibleFaces;

    CubeDefinition(@Nullable String comment, float texCoordU, float texCoordV, float originX, float originY, float originZ, float dimensionX, float dimensionY, float dimensionZ, CubeDeformation grow, boolean mirror, float texScaleU, float texScaleV, Set<Direction> visibleFaces) {
        this.texCoord = new UVPair(texCoordU, texCoordV);
        this.origin = new Vector3f(originX, originY, originZ);
        this.dimensions = new Vector3f(dimensionX, dimensionY, dimensionZ);
        this.grow = grow;
        this.mirror = mirror;
        this.texScale = new UVPair(texScaleU, texScaleV);
        this.visibleFaces = visibleFaces;
    }

    public NeoModelPart.Cube bake(int texWidth, int texHeight) {
        return new NeoModelPart.Cube((int)this.texCoord.u(), (int)this.texCoord.v(), this.origin.func_195899_a(), this.origin.func_195900_b(), this.origin.func_195902_c(), this.dimensions.func_195899_a(), this.dimensions.func_195900_b(), this.dimensions.func_195902_c(), this.grow.growX, this.grow.growY, this.grow.growZ, this.mirror, (float)texWidth * this.texScale.u(), (float)texHeight * this.texScale.v(), this.visibleFaces);
    }
}

