/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.client.resource;

import com.blackgear.platform.core.mixin.access.CameraAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NearPlane {
    public final Vector3d forward;
    public final Vector3d left;
    public final Vector3d up;

    public NearPlane(Vector3d forward, Vector3d left, Vector3d up) {
        this.forward = forward;
        this.left = left;
        this.up = up;
    }

    public Vector3d getTopLeft() {
        return this.forward.func_178787_e(this.up).func_178787_e(this.left);
    }

    public Vector3d getTopRight() {
        return this.forward.func_178787_e(this.up).func_178788_d(this.left);
    }

    public Vector3d getBottomLeft() {
        return this.forward.func_178788_d(this.up).func_178787_e(this.left);
    }

    public Vector3d getBottomRight() {
        return this.forward.func_178788_d(this.up).func_178788_d(this.left);
    }

    public Vector3d getPointOnPlane(float leftScale, float upScale) {
        return this.forward.func_178787_e(this.up.func_186678_a((double)upScale)).func_178788_d(this.left.func_186678_a((double)leftScale));
    }

    public static NearPlane getNearPlane(ActiveRenderInfo camera) {
        CameraAccessor access = (CameraAccessor)camera;
        Minecraft minecraft = Minecraft.func_71410_x();
        double aspectRatio = (double)minecraft.func_228018_at_().func_198109_k() / (double)minecraft.func_228018_at_().func_198091_l();
        double halfFOVScaled = Math.tan(minecraft.field_71474_y.field_74334_X * 0.01745329238474369 / 2.0) * (double)0.05f;
        double scaledAspectRatio = halfFOVScaled * aspectRatio;
        Vector3d forward = new Vector3d(access.getForwards()).func_186678_a((double)0.05f);
        Vector3d left = new Vector3d(access.getLeft()).func_186678_a(scaledAspectRatio);
        Vector3d up = new Vector3d(access.getUp()).func_186678_a(halfFOVScaled);
        return new NearPlane(forward, left, up);
    }
}

