/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.client.resource;

import com.blackgear.platform.common.providers.math.IntProvider;
import com.blackgear.platform.common.providers.math.UniformInt;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class ParticleUtils {
    public static void spawnParticleOnBlockFaces(World level, BlockPos pos, IParticleData particle, IntProvider particleCountProvider) {
        for (Direction direction : Direction.values()) {
            ParticleUtils.spawnParticleOnBlockFace(level, pos, particle, particleCountProvider, direction, () -> ParticleUtils.getRandomSpeedRanges(level.field_73012_v), 0.55);
        }
    }

    private static void spawnParticleOnBlockFace(World level, BlockPos pos, IParticleData particle, IntProvider particleCountProvider, Direction faceDirection, Supplier<Vector3d> speedSupplier, double speedMultiplier) {
        int particleCount = particleCountProvider.sample(level.field_73012_v);
        for (int i = 0; i < particleCount; ++i) {
            ParticleUtils.spawnParticleOnFace(level, pos, faceDirection, particle, speedSupplier.get(), speedMultiplier);
        }
    }

    private static Vector3d getRandomSpeedRanges(Random random) {
        return new Vector3d(MathHelper.func_82716_a((Random)random, (double)-0.5, (double)0.5), MathHelper.func_82716_a((Random)random, (double)-0.5, (double)0.5), MathHelper.func_82716_a((Random)random, (double)-0.5, (double)0.5));
    }

    public static void spawnParticlesAlongAxis(Direction.Axis axis, World level, BlockPos pos, double range, IParticleData particle, UniformInt particleCount) {
        Vector3d centerPos = Vector3d.func_237489_a_((Vector3i)pos);
        boolean xAxis = axis == Direction.Axis.X;
        boolean yAxis = axis == Direction.Axis.Y;
        boolean zAxis = axis == Direction.Axis.Z;
        int count = particleCount.sample(level.field_73012_v);
        for (int i = 0; i < count; ++i) {
            double offsetX = centerPos.field_72450_a + MathHelper.func_82716_a((Random)level.field_73012_v, (double)-1.0, (double)1.0) * (xAxis ? 0.5 : range);
            double offsetY = centerPos.field_72448_b + MathHelper.func_82716_a((Random)level.field_73012_v, (double)-1.0, (double)1.0) * (yAxis ? 0.5 : range);
            double offsetZ = centerPos.field_72449_c + MathHelper.func_82716_a((Random)level.field_73012_v, (double)-1.0, (double)1.0) * (zAxis ? 0.5 : range);
            double speedX = xAxis ? MathHelper.func_82716_a((Random)level.field_73012_v, (double)-1.0, (double)1.0) : 0.0;
            double speedY = yAxis ? MathHelper.func_82716_a((Random)level.field_73012_v, (double)-1.0, (double)1.0) : 0.0;
            double speedZ = zAxis ? MathHelper.func_82716_a((Random)level.field_73012_v, (double)-1.0, (double)1.0) : 0.0;
            level.func_195594_a(particle, offsetX, offsetY, offsetZ, speedX, speedY, speedZ);
        }
    }

    private static void spawnParticleOnFace(World level, BlockPos pos, Direction faceDirection, IParticleData particle, Vector3d speed, double speedMultiplier) {
        Vector3d centerPos = Vector3d.func_237489_a_((Vector3i)pos);
        int stepX = faceDirection.func_82601_c();
        int stepY = faceDirection.func_96559_d();
        int stepZ = faceDirection.func_82599_e();
        double offsetX = centerPos.field_72450_a + (stepX == 0 ? MathHelper.func_82716_a((Random)level.field_73012_v, (double)-0.5, (double)0.5) : (double)stepX * speedMultiplier);
        double offsetY = centerPos.field_72448_b + (stepY == 0 ? MathHelper.func_82716_a((Random)level.field_73012_v, (double)-0.5, (double)0.5) : (double)stepY * speedMultiplier);
        double offsetZ = centerPos.field_72449_c + (stepZ == 0 ? MathHelper.func_82716_a((Random)level.field_73012_v, (double)-0.5, (double)0.5) : (double)stepZ * speedMultiplier);
        double speedX = stepX == 0 ? speed.func_82615_a() : 0.0;
        double speedY = stepY == 0 ? speed.func_82617_b() : 0.0;
        double speedZ = stepZ == 0 ? speed.func_82616_c() : 0.0;
        level.func_195594_a(particle, offsetX, offsetY, offsetZ, speedX, speedY, speedZ);
    }

    public static void spawnParticleBelow(World level, BlockPos pos, Random random, IParticleData particle) {
        double posX = (double)pos.func_177958_n() + random.nextDouble();
        double posY = (double)pos.func_177956_o() - 0.05;
        double posZ = (double)pos.func_177952_p() + random.nextDouble();
        level.func_195594_a(particle, posX, posY, posZ, 0.0, 0.0, 0.0);
    }
}

