/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.block;

import com.blackgear.platform.common.block.BlockPropertiesExtension;
import com.blackgear.platform.common.block.ToolType;
import com.blackgear.platform.common.block.forge.BlockPropertiesBuilderImpl;
import com.blackgear.platform.core.util.function.ToFloatFunction;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.EntityType;
import net.minecraft.item.DyeColor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public final class BlockProperties {
    public static Builder of(Material material) {
        return new Builder(AbstractBlock.Properties.func_200945_a((Material)material));
    }

    public static Builder of(Material material, DyeColor color) {
        return new Builder(AbstractBlock.Properties.func_200952_a((Material)material, (DyeColor)color));
    }

    public static Builder of(Material material, MaterialColor color) {
        return new Builder(AbstractBlock.Properties.func_200949_a((Material)material, (MaterialColor)color));
    }

    public static Builder of(Material material, Function<BlockState, MaterialColor> colorByState) {
        return new Builder(AbstractBlock.Properties.func_235836_a_((Material)material, colorByState));
    }

    public static Builder copy(Block block) {
        return new Builder(AbstractBlock.Properties.func_200950_a((AbstractBlock)block));
    }

    public static boolean never(BlockState state, IBlockReader level, BlockPos pos, EntityType<?> entity) {
        return false;
    }

    public static boolean always(BlockState state, IBlockReader level, BlockPos pos, EntityType<?> entity) {
        return true;
    }

    public static boolean ocelotOrParrot(BlockState state, IBlockReader level, BlockPos pos, EntityType<?> entity) {
        return entity == EntityType.field_200781_U || entity == EntityType.field_200783_W;
    }

    public static boolean never(BlockState state, IBlockReader level, BlockPos pos) {
        return false;
    }

    public static boolean always(BlockState state, IBlockReader level, BlockPos pos) {
        return true;
    }

    public static class Builder {
        private final AbstractBlock.Properties properties;

        public Builder(AbstractBlock.Properties properties) {
            this.properties = properties;
        }

        public Builder color(MaterialColor color) {
            this.properties.field_235800_b_ = state -> color;
            return this;
        }

        public Builder noCollision() {
            this.properties.func_200942_a();
            return this;
        }

        public Builder noOcclusion() {
            this.properties.func_226896_b_();
            return this;
        }

        public Builder friction(float friction) {
            this.properties.func_200941_a(friction);
            return this;
        }

        public Builder speedFactor(float speedFactor) {
            this.properties.func_226897_b_(speedFactor);
            return this;
        }

        public Builder jumpFactor(float jumpFactor) {
            this.properties.func_226898_c_(jumpFactor);
            return this;
        }

        public Builder sound(SoundType sound) {
            this.properties.func_200947_a(sound);
            return this;
        }

        public Builder lightLevel(ToIntFunction<BlockState> lightByState) {
            this.properties.func_235838_a_(lightByState);
            return this;
        }

        public Builder strength(float destroyTime, float explosionResistance) {
            this.properties.func_200948_a(destroyTime, explosionResistance);
            return this;
        }

        public Builder instabreak() {
            this.properties.func_200946_b();
            return this;
        }

        public Builder strength(float strength) {
            this.properties.func_200948_a(strength, strength);
            return this;
        }

        public Builder randomTicks() {
            this.properties.func_200944_c();
            return this;
        }

        public Builder dynamicShape() {
            this.properties.func_208770_d();
            return this;
        }

        public Builder noDrops() {
            this.properties.func_222380_e();
            return this;
        }

        public Builder dropsLike(Block block) {
            this.properties.func_222379_b(block);
            return this;
        }

        public Builder air() {
            this.properties.func_235859_g_();
            return this;
        }

        public Builder isValidSpawn(AbstractBlock.IExtendedPositionPredicate<EntityType<?>> isValidSpawn) {
            this.properties.func_235827_a_(isValidSpawn);
            return this;
        }

        public Builder isRedstoneConductor(AbstractBlock.IPositionPredicate isRedstoneConductor) {
            this.properties.func_235828_a_(isRedstoneConductor);
            return this;
        }

        public Builder isSuffocating(AbstractBlock.IPositionPredicate isSuffocating) {
            this.properties.func_235842_b_(isSuffocating);
            return this;
        }

        public Builder isViewBlocking(AbstractBlock.IPositionPredicate isViewBlocking) {
            this.properties.func_235847_c_(isViewBlocking);
            return this;
        }

        public Builder hasPostProcess(AbstractBlock.IPositionPredicate hasPostProcess) {
            this.properties.func_235852_d_(hasPostProcess);
            return this;
        }

        public Builder emissiveRendering(AbstractBlock.IPositionPredicate emissiveRendering) {
            this.properties.func_235856_e_(emissiveRendering);
            return this;
        }

        public Builder requiresCorrectToolForDrops() {
            this.properties.func_235861_h_();
            return this;
        }

        public Builder correctToolForDrops(ToolType toolType, int level) {
            Builder.registerToolType(this.properties, toolType, level);
            return this;
        }

        public Builder correctToolForDrops(ToolType toolType) {
            Builder.registerToolType(this.properties, toolType, 0);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @ExpectPlatform
        @ExpectPlatform.Transformed
        public static void registerToolType(AbstractBlock.Properties properties, ToolType toolType, int level) {
            void var2_2;
            void var1_1;
            BlockPropertiesBuilderImpl.registerToolType(properties, (ToolType)var1_1, (int)var2_2);
        }

        public Builder pushReaction(PushReaction reaction) {
            ((BlockPropertiesExtension)this.properties).setPushReaction(reaction);
            return this;
        }

        public Builder offsetType(AbstractBlock.OffsetType offset) {
            ((BlockPropertiesExtension)this.properties).setOffsetType(offset);
            return this;
        }

        public Builder maxHorizontalOffset(ToFloatFunction<BlockState> offsetByState) {
            ((BlockPropertiesExtension)this.properties).setMaxHorizontalOffset(offsetByState);
            return this;
        }

        public Builder maxVerticalOffset(ToFloatFunction<BlockState> offsetByState) {
            ((BlockPropertiesExtension)this.properties).setMaxVerticalOffset(offsetByState);
            return this;
        }

        public AbstractBlock.Properties build() {
            return this.properties;
        }
    }
}

