/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.block.entries;

import com.blackgear.platform.common.block.entries.MultifaceSpreader;
import com.blackgear.platform.core.util.BlockUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SixWayBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public abstract class MultifaceBlock
extends Block {
    private static final VoxelShape UP_AABB = Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape DOWN_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape WEST_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_AABB = Block.func_208617_a((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape SOUTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = SixWayBlock.field_196491_B;
    private static final Map<Direction, VoxelShape> SHAPE_BY_DIRECTION = (Map)Util.func_200696_a((Object)Maps.newEnumMap(Direction.class), shape -> {
        shape.put(Direction.NORTH, NORTH_AABB);
        shape.put(Direction.EAST, EAST_AABB);
        shape.put(Direction.SOUTH, SOUTH_AABB);
        shape.put(Direction.WEST, WEST_AABB);
        shape.put(Direction.UP, UP_AABB);
        shape.put(Direction.DOWN, DOWN_AABB);
    });
    private final ImmutableMap<BlockState, VoxelShape> shapesCache;
    private final boolean canRotate;
    private final boolean canMirrorX;
    private final boolean canMirrorZ;

    public MultifaceBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j(MultifaceBlock.getDefaultMultiFaceState((StateContainer<Block, BlockState>)this.field_176227_L));
        this.shapesCache = BlockUtils.getShapeForEachState(this, MultifaceBlock::calculateMultifaceShape);
        this.canRotate = Direction.Plane.HORIZONTAL.func_239636_a_().allMatch(this::isFaceSupported);
        this.canMirrorX = Direction.Plane.HORIZONTAL.func_239636_a_().filter(Direction.Axis.X).filter(this::isFaceSupported).count() % 2L == 0L;
        this.canMirrorZ = Direction.Plane.HORIZONTAL.func_239636_a_().filter(Direction.Axis.Z).filter(this::isFaceSupported).count() % 2L == 0L;
    }

    public static Set<Direction> availableFaces(BlockState state) {
        if (state.func_177230_c() instanceof MultifaceBlock) {
            EnumSet<Direction> faces = EnumSet.noneOf(Direction.class);
            for (Direction direction : Direction.values()) {
                if (!MultifaceBlock.hasFace(state, direction)) continue;
                faces.add(direction);
            }
            return faces;
        }
        return ImmutableSet.of();
    }

    public static Set<Direction> unpack(byte face) {
        EnumSet<Direction> faces = EnumSet.noneOf(Direction.class);
        for (Direction direction : Direction.values()) {
            if ((face & (byte)(1 << direction.ordinal())) <= 0) continue;
            faces.add(direction);
        }
        return faces;
    }

    public static byte pack(Collection<Direction> directions) {
        byte face = 0;
        for (Direction direction : directions) {
            face = (byte)(face | 1 << direction.ordinal());
        }
        return face;
    }

    protected boolean isFaceSupported(Direction direction) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        for (Direction direction : Direction.values()) {
            if (!this.isFaceSupported(direction)) continue;
            builder.func_206894_a(new Property[]{MultifaceBlock.getFaceProperty(direction)});
        }
    }

    public BlockState func_196271_a(BlockState currentState, Direction direction, BlockState neighborState, IWorld level, BlockPos currentPos, BlockPos neighborPos) {
        if (!MultifaceBlock.hasAnyFace(currentState)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (MultifaceBlock.hasFace(currentState, direction) && !MultifaceBlock.canAttachTo((IBlockReader)level, direction, neighborPos, neighborState)) {
            return MultifaceBlock.removeFace(currentState, MultifaceBlock.getFaceProperty(direction));
        }
        return currentState;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader level, BlockPos pos, ISelectionContext context) {
        return (VoxelShape)this.shapesCache.get((Object)state);
    }

    public boolean func_196260_a(BlockState state, IWorldReader level, BlockPos pos) {
        boolean canSurvive = false;
        for (Direction direction : Direction.values()) {
            if (!MultifaceBlock.hasFace(state, direction)) continue;
            BlockPos blockPos = pos.func_177972_a(direction);
            if (!MultifaceBlock.canAttachTo((IBlockReader)level, direction, blockPos, level.func_180495_p(blockPos))) {
                return false;
            }
            canSurvive = true;
        }
        return canSurvive;
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext context) {
        return MultifaceBlock.hasAnyVacantFace(state);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        World level = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState state = level.func_180495_p(pos);
        return Arrays.stream(context.func_196009_e()).map(direction -> this.getStateForPlacement(state, (IBlockReader)level, pos, (Direction)direction)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public boolean isValidStateForPlacement(IBlockReader level, BlockState state, BlockPos pos, Direction direction) {
        if (!(!this.isFaceSupported(direction) || state.func_203425_a((Block)this) && MultifaceBlock.hasFace(state, direction))) {
            BlockPos blockPos = pos.func_177972_a(direction);
            return MultifaceBlock.canAttachTo(level, direction, blockPos, level.func_180495_p(blockPos));
        }
        return false;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockState state, IBlockReader level, BlockPos pos, Direction direction) {
        if (!this.isValidStateForPlacement(level, state, pos, direction)) {
            return null;
        }
        BlockState blockState = state.func_203425_a((Block)this) ? state : (this.isWaterloggable() && BlockUtils.isSourceOfWater(state.func_204520_s()) ? (BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)) : this.func_176223_P());
        return (BlockState)blockState.func_206870_a((Property)MultifaceBlock.getFaceProperty(direction), (Comparable)Boolean.valueOf(true));
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        if (!this.canRotate) {
            return state;
        }
        return this.mapDirections(state, arg_0 -> ((Rotation)rotation).func_185831_a(arg_0));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        if (mirror == Mirror.FRONT_BACK && !this.canMirrorX) {
            return state;
        }
        if (mirror == Mirror.LEFT_RIGHT && !this.canMirrorZ) {
            return state;
        }
        return this.mapDirections(state, arg_0 -> ((Mirror)mirror).func_185803_b(arg_0));
    }

    private BlockState mapDirections(BlockState state, Function<Direction, Direction> faces) {
        BlockState blockState = state;
        for (Direction direction : Direction.values()) {
            if (!this.isFaceSupported(direction)) continue;
            blockState = (BlockState)blockState.func_206870_a((Property)MultifaceBlock.getFaceProperty(faces.apply(direction)), (Comparable)((Boolean)state.func_177229_b((Property)MultifaceBlock.getFaceProperty(direction))));
        }
        return blockState;
    }

    public static boolean hasFace(BlockState state, Direction direction) {
        BooleanProperty faceProperty = MultifaceBlock.getFaceProperty(direction);
        return state.func_235901_b_((Property)faceProperty) && (Boolean)state.func_177229_b((Property)faceProperty) != false;
    }

    public static boolean canAttachTo(IBlockReader level, Direction direction, BlockPos pos, BlockState state) {
        return Block.func_208061_a((VoxelShape)state.func_196951_e(level, pos), (Direction)direction.func_176734_d()) || Block.func_208061_a((VoxelShape)state.func_196952_d(level, pos), (Direction)direction.func_176734_d());
    }

    private boolean isWaterloggable() {
        return this.func_176194_O().func_177623_d().contains(BlockStateProperties.field_208198_y);
    }

    private static BlockState removeFace(BlockState state, BooleanProperty property) {
        BlockState blockState = (BlockState)state.func_206870_a((Property)property, (Comparable)Boolean.valueOf(false));
        return MultifaceBlock.hasAnyFace(blockState) ? blockState : Blocks.field_150350_a.func_176223_P();
    }

    public static BooleanProperty getFaceProperty(Direction direction) {
        return PROPERTY_BY_DIRECTION.get(direction);
    }

    private static BlockState getDefaultMultiFaceState(StateContainer<Block, BlockState> definition) {
        BlockState state = (BlockState)definition.func_177621_b();
        for (BooleanProperty property : PROPERTY_BY_DIRECTION.values()) {
            if (!state.func_235901_b_((Property)property)) continue;
            state = (BlockState)state.func_206870_a((Property)property, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    private static VoxelShape calculateMultifaceShape(BlockState state) {
        VoxelShape shape = VoxelShapes.func_197880_a();
        for (Direction direction : Direction.values()) {
            if (!MultifaceBlock.hasFace(state, direction)) continue;
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_BY_DIRECTION.get(direction));
        }
        return shape.func_197766_b() ? VoxelShapes.func_197868_b() : shape;
    }

    protected static boolean hasAnyFace(BlockState state) {
        return Arrays.stream(Direction.values()).anyMatch(direction -> MultifaceBlock.hasFace(state, direction));
    }

    private static boolean hasAnyVacantFace(BlockState state) {
        return Arrays.stream(Direction.values()).anyMatch(direction -> !MultifaceBlock.hasFace(state, direction));
    }

    public abstract MultifaceSpreader getSpreader();
}

