/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.block.entries;

import com.blackgear.platform.common.block.entries.MultifaceBlock;
import com.blackgear.platform.core.util.DirectionUtils;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import org.jetbrains.annotations.Nullable;

public class MultifaceSpreader {
    public static final SpreadType[] DEFAULT_SPREAD_ORDER = new SpreadType[]{SpreadType.SAME_POSITION, SpreadType.SAME_PLANE, SpreadType.WRAP_AROUND};
    private final SpreadConfig config;

    public MultifaceSpreader(MultifaceBlock block) {
        this(new DefaultSpreaderConfig(block));
    }

    public MultifaceSpreader(SpreadConfig config) {
        this.config = config;
    }

    public boolean canSpreadInAnyDirection(BlockState state, IBlockReader level, BlockPos pos, Direction spreadDirection) {
        return DirectionUtils.stream().anyMatch(dir -> this.getSpreadFromFaceTowardDirection(state, level, pos, spreadDirection, (Direction)dir, this.config::canSpreadInto).isPresent());
    }

    public Optional<SpreadPos> spreadFromRandomFaceTowardRandomDirection(BlockState state, IWorld level, BlockPos pos, Random random) {
        return DirectionUtils.allShuffled(random).stream().filter(direction -> this.config.canSpreadFrom(state, (Direction)direction)).map(direction -> this.spreadFromFaceTowardRandomDirection(state, level, pos, (Direction)direction, random, false)).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    public long spreadAll(BlockState state, IWorld level, BlockPos pos, boolean markForPostprocessing) {
        return DirectionUtils.stream().filter(direction -> this.config.canSpreadFrom(state, (Direction)direction)).map(direction -> this.spreadFromFaceTowardAllDirections(state, level, pos, (Direction)direction, markForPostprocessing)).reduce(0L, Long::sum);
    }

    public Optional<SpreadPos> spreadFromFaceTowardRandomDirection(BlockState state, IWorld level, BlockPos pos, Direction spreadDirection, Random random, boolean markForPostprocessing) {
        return DirectionUtils.allShuffled(random).stream().map(dir -> this.spreadFromFaceTowardDirection(state, level, pos, spreadDirection, (Direction)dir, markForPostprocessing)).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    private long spreadFromFaceTowardAllDirections(BlockState state, IWorld level, BlockPos pos, Direction spreadDirection, boolean markForPostprocessing) {
        return DirectionUtils.stream().map(dir -> this.spreadFromFaceTowardDirection(state, level, pos, spreadDirection, (Direction)dir, markForPostprocessing)).filter(Optional::isPresent).count();
    }

    public Optional<SpreadPos> spreadFromFaceTowardDirection(BlockState state, IWorld level, BlockPos pos, Direction spreadDirection, Direction face, boolean markForPostprocessing) {
        return this.getSpreadFromFaceTowardDirection(state, (IBlockReader)level, pos, spreadDirection, face, this.config::canSpreadInto).flatMap(spreadPos -> this.spreadToFace(level, (SpreadPos)spreadPos, markForPostprocessing));
    }

    public Optional<SpreadPos> getSpreadFromFaceTowardDirection(BlockState state, IBlockReader level, BlockPos pos, Direction spreadDirection, Direction face, SpreadPredicate spreadPredicate) {
        if (face.func_176740_k() == spreadDirection.func_176740_k()) {
            return Optional.empty();
        }
        if (!(this.config.isOtherBlockValidAsSource(state) || this.config.hasFace(state, spreadDirection) && !this.config.hasFace(state, face))) {
            return Optional.empty();
        }
        for (SpreadType spreadType : this.config.getSpreadTypes()) {
            SpreadPos spreadPos = spreadType.getSpreadPos(pos, face, spreadDirection);
            if (!spreadPredicate.test(level, pos, spreadPos)) continue;
            return Optional.of(spreadPos);
        }
        return Optional.empty();
    }

    public Optional<SpreadPos> spreadToFace(IWorld level, SpreadPos pos, boolean markForPostprocessing) {
        BlockState state = level.func_180495_p(pos.pos);
        return this.config.placeBlock(level, pos, state, markForPostprocessing) ? Optional.of(pos) : Optional.empty();
    }

    public static class DefaultSpreaderConfig
    implements SpreadConfig {
        protected final MultifaceBlock block;

        public DefaultSpreaderConfig(MultifaceBlock block) {
            this.block = block;
        }

        @Override
        @Nullable
        public BlockState getStateForPlacement(BlockState currentState, IBlockReader level, BlockPos pos, Direction lookingDirection) {
            return this.block.getStateForPlacement(currentState, level, pos, lookingDirection);
        }

        protected boolean stateCanBeReplaced(IBlockReader level, BlockPos sourcePos, BlockPos targetPos, Direction direction, BlockState state) {
            return state.func_196958_f() || state.func_203425_a((Block)this.block) || state.func_203425_a(Blocks.field_150355_j) && state.func_204520_s().func_206889_d();
        }

        @Override
        public boolean canSpreadInto(IBlockReader level, BlockPos pos, SpreadPos spreadPos) {
            BlockState state = level.func_180495_p(spreadPos.pos);
            return this.stateCanBeReplaced(level, pos, spreadPos.pos, spreadPos.face, state) && this.block.isValidStateForPlacement(level, state, spreadPos.pos, spreadPos.face);
        }
    }

    public static interface SpreadConfig {
        @Nullable
        public BlockState getStateForPlacement(BlockState var1, IBlockReader var2, BlockPos var3, Direction var4);

        public boolean canSpreadInto(IBlockReader var1, BlockPos var2, SpreadPos var3);

        default public SpreadType[] getSpreadTypes() {
            return DEFAULT_SPREAD_ORDER;
        }

        default public boolean hasFace(BlockState state, Direction direction) {
            return MultifaceBlock.hasFace(state, direction);
        }

        default public boolean isOtherBlockValidAsSource(BlockState state) {
            return false;
        }

        default public boolean canSpreadFrom(BlockState state, Direction direction) {
            return this.isOtherBlockValidAsSource(state) || this.hasFace(state, direction);
        }

        default public boolean placeBlock(IWorld level, SpreadPos spreadPos, BlockState state, boolean postProcess) {
            BlockState blockState = this.getStateForPlacement(state, (IBlockReader)level, spreadPos.pos, spreadPos.face);
            if (blockState != null) {
                if (postProcess) {
                    level.func_217349_x(spreadPos.pos).func_201594_d(spreadPos.pos);
                }
                return level.func_180501_a(spreadPos.pos, blockState, 2);
            }
            return false;
        }
    }

    public static interface SpreadPredicate {
        public boolean test(IBlockReader var1, BlockPos var2, SpreadPos var3);
    }

    public static enum SpreadType {
        SAME_POSITION{

            @Override
            public SpreadPos getSpreadPos(BlockPos pos, Direction face, Direction spreadDirection) {
                return new SpreadPos(pos, face);
            }
        }
        ,
        SAME_PLANE{

            @Override
            public SpreadPos getSpreadPos(BlockPos pos, Direction face, Direction spreadDirection) {
                return new SpreadPos(pos.func_177972_a(face), spreadDirection);
            }
        }
        ,
        WRAP_AROUND{

            @Override
            public SpreadPos getSpreadPos(BlockPos pos, Direction face, Direction spreadDirection) {
                return new SpreadPos(pos.func_177972_a(face).func_177972_a(spreadDirection), face.func_176734_d());
            }
        };


        public abstract SpreadPos getSpreadPos(BlockPos var1, Direction var2, Direction var3);
    }

    public static class SpreadPos {
        private final BlockPos pos;
        private final Direction face;

        public SpreadPos(BlockPos pos, Direction face) {
            this.pos = pos;
            this.face = face;
        }
    }
}

