/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.block.entries;

import com.blackgear.platform.common.block.entries.VanillaGrowingPlantBlock;
import com.blackgear.platform.common.block.entries.VanillaGrowingPlantHeadBlock;
import com.blackgear.platform.core.util.BlockUtils;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class VanillaGrowingPlantBodyBlock
extends VanillaGrowingPlantBlock
implements IGrowable {
    protected VanillaGrowingPlantBodyBlock(AbstractBlock.Properties properties, Direction growthDirection, VoxelShape shape, boolean scheduleFluidTicks) {
        super(properties, growthDirection, shape, scheduleFluidTicks);
    }

    protected BlockState updateHeadAfterConvertedFromBody(BlockState head, BlockState body) {
        return body;
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState neighborState, IWorld level, BlockPos currentPos, BlockPos neighborPos) {
        if (direction == this.growthDirection.func_176734_d() && !state.func_196955_c((IWorldReader)level, currentPos)) {
            level.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        VanillaGrowingPlantHeadBlock headBlock = this.getHeadBlock();
        if (direction == this.growthDirection && !neighborState.func_203425_a((Block)this) && !neighborState.func_203425_a((Block)headBlock)) {
            return this.updateHeadAfterConvertedFromBody(state, headBlock.getStateForPlacement(level));
        }
        if (this.scheduleFluidTicks) {
            level.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)level));
        }
        return super.func_196271_a(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public ItemStack func_185473_a(IBlockReader level, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)this.getHeadBlock());
    }

    public boolean func_176473_a(IBlockReader level, BlockPos pos, BlockState state, boolean isClient) {
        Optional<BlockPos> headPos = this.getHeadPos(level, pos, state.func_177230_c());
        return headPos.isPresent() && this.getHeadBlock().canGrowInto(level.func_180495_p(headPos.get().func_177972_a(this.growthDirection)));
    }

    public boolean func_180670_a(World level, Random random, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld level, Random random, BlockPos pos, BlockState state) {
        Optional<BlockPos> headPos = this.getHeadPos((IBlockReader)level, pos, state.func_177230_c());
        if (headPos.isPresent()) {
            BlockState headState = level.func_180495_p(headPos.get());
            ((VanillaGrowingPlantHeadBlock)headState.func_177230_c()).func_225535_a_(level, random, headPos.get(), headState);
        }
    }

    private Optional<BlockPos> getHeadPos(IBlockReader level, BlockPos pos, Block block) {
        return BlockUtils.getTopConnectedBlock(level, pos, block, this.growthDirection, this.getHeadBlock());
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        boolean result = super.func_196253_a(state, useContext);
        return result && useContext.func_195996_i().func_77973_b() == this.getHeadBlock().func_199767_j() || result;
    }

    @Override
    protected Block getBodyBlock() {
        return this;
    }
}

