/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.block.entries;

import com.blackgear.platform.common.block.entries.VanillaGrowingPlantBlock;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class VanillaGrowingPlantHeadBlock
extends VanillaGrowingPlantBlock
implements IGrowable {
    public static final IntegerProperty AGE = BlockStateProperties.field_208172_Y;
    public static final int MAX_AGE = 25;
    private final double growPerTickProbability;

    public VanillaGrowingPlantHeadBlock(AbstractBlock.Properties properties, Direction growthDirection, VoxelShape shape, boolean scheduleFluidTicks, double growPerTickProbability) {
        super(properties, growthDirection, shape, scheduleFluidTicks);
        this.growPerTickProbability = growPerTickProbability;
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    @Override
    public BlockState getStateForPlacement(IWorld level) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)AGE, (Comparable)Integer.valueOf(level.func_201674_k().nextInt(25)));
    }

    public boolean func_149653_t(BlockState state) {
        return (Integer)state.func_177229_b((Property)AGE) < 25;
    }

    public void func_225542_b_(BlockState state, ServerWorld level, BlockPos pos, Random random) {
        BlockPos offset;
        if ((Integer)state.func_177229_b((Property)AGE) < 25 && random.nextDouble() < this.growPerTickProbability && this.canGrowInto(level.func_180495_p(offset = pos.func_177972_a(this.growthDirection)))) {
            level.func_175656_a(offset, this.getGrowIntoState(state, level.field_73012_v));
        }
    }

    protected BlockState getGrowIntoState(BlockState state, Random random) {
        return (BlockState)state.func_235896_a_((Property)AGE);
    }

    public BlockState getMaxAgeState(BlockState state) {
        return (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(25));
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.func_177229_b((Property)AGE) == 25;
    }

    protected BlockState updateBodyAfterConvertedFromHead(BlockState head, BlockState body) {
        return body;
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState neighborState, IWorld level, BlockPos currentPos, BlockPos neighborPos) {
        if (direction == this.growthDirection.func_176734_d() && !state.func_196955_c((IWorldReader)level, currentPos)) {
            level.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        if (direction != this.growthDirection || !neighborState.func_203425_a((Block)this) && !neighborState.func_203425_a(this.getBodyBlock())) {
            if (this.scheduleFluidTicks) {
                level.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)level));
            }
            return super.func_196271_a(state, direction, neighborState, level, currentPos, neighborPos);
        }
        return this.updateBodyAfterConvertedFromHead(state, this.getBodyBlock().func_176223_P());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AGE});
    }

    public boolean func_176473_a(IBlockReader level, BlockPos pos, BlockState state, boolean isClient) {
        return this.canGrowInto(level.func_180495_p(pos.func_177972_a(this.growthDirection)));
    }

    public boolean func_180670_a(World level, Random random, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld level, Random random, BlockPos pos, BlockState state) {
        BlockPos offset = pos.func_177972_a(this.growthDirection);
        int age = Math.min((Integer)state.func_177229_b((Property)AGE) + 1, 25);
        int blocksToGrow = this.getBlocksToGrowWhenBonemealed(random);
        for (int i = 0; i < blocksToGrow && this.canGrowInto(level.func_180495_p(offset)); ++i) {
            level.func_175656_a(offset, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(age)));
            offset = offset.func_177972_a(this.growthDirection);
            age = Math.min(age + 1, 25);
        }
    }

    protected abstract int getBlocksToGrowWhenBonemealed(Random var1);

    protected abstract boolean canGrowInto(BlockState var1);

    @Override
    protected VanillaGrowingPlantHeadBlock getHeadBlock() {
        return this;
    }
}

