/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.entity;

import java.util.function.Supplier;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.Heightmap;
import org.jetbrains.annotations.Nullable;

public final class SpawnPlacement {
    public static <T extends MobEntity> void register(Supplier<EntityType<T>> entity, EntitySpawnPlacementRegistry.PlacementType placement, Heightmap.Type heightmap, EntitySpawnPlacementRegistry.IPlacementPredicate<T> spawnPredicate) {
        EntitySpawnPlacementRegistry.Entry data = new EntitySpawnPlacementRegistry.Entry(heightmap, placement, spawnPredicate);
        SpawnPlacement.registerOrReplaceEntityData(entity, data);
    }

    public static <T extends MobEntity> void register(Supplier<EntityType<T>> entity, SpawnPlacementType placement, Heightmap.Type heightmap, EntitySpawnPlacementRegistry.IPlacementPredicate<T> spawnPredicate) {
        EntitySpawnPlacementRegistry.Entry data = new EntitySpawnPlacementRegistry.Entry(heightmap, EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, (entityType, level, spawnType, pos, random) -> placement.isSpawnPositionValid((IWorldReader)level, pos, entityType) && spawnPredicate.test((EntityType)entity.get(), level, spawnType, pos, random));
        SpawnPlacement.registerOrReplaceEntityData(entity, data);
    }

    private static <T extends MobEntity> void registerOrReplaceEntityData(Supplier<EntityType<T>> entity, EntitySpawnPlacementRegistry.Entry data) {
        EntitySpawnPlacementRegistry.Entry entry = EntitySpawnPlacementRegistry.field_209347_a.put(entity.get(), data);
        if (entry != null) {
            EntitySpawnPlacementRegistry.field_209347_a.replace(entity.get(), data);
        }
    }

    public static interface SpawnPlacementType {
        public boolean isSpawnPositionValid(IWorldReader var1, BlockPos var2, @Nullable EntityType<?> var3);
    }
}

