/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.entity.forge;

import com.blackgear.platform.common.entity.TradeRegistry;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.util.NonNullList;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="platform", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TradeRegistryImpl {
    private static final Map<VillagerProfession, Int2ObjectMap<List<VillagerTrades.ITrade>>> VILLAGER_TRADES = new HashMap<VillagerProfession, Int2ObjectMap<List<VillagerTrades.ITrade>>>();
    private static final List<VillagerTrades.ITrade> WANDERING_TRADER_GENERICS = new ArrayList<VillagerTrades.ITrade>();
    private static final List<VillagerTrades.ITrade> WANDERING_TRADER_RARES = new ArrayList<VillagerTrades.ITrade>();

    public static void addVillagerTrades(VillagerProfession profession, TradeRegistry.VillagerLevel level, VillagerTrades.ITrade ... trades) {
        Int2ObjectMap perProfession = VILLAGER_TRADES.computeIfAbsent(profession, trade -> new Int2ObjectOpenHashMap());
        List perLevel = (List)perProfession.computeIfAbsent(level.getValue(), trade -> new ArrayList());
        Collections.addAll(perLevel, trades);
    }

    @SubscribeEvent
    public static void registerVillagerTrades(VillagerTradesEvent event) {
        Int2ObjectMap<List<VillagerTrades.ITrade>> trades = VILLAGER_TRADES.get(event.getType());
        if (trades != null) {
            for (Int2ObjectMap.Entry entry : trades.int2ObjectEntrySet()) {
                ((List)event.getTrades().computeIfAbsent(entry.getIntKey(), level -> NonNullList.func_191196_a())).addAll((Collection)entry.getValue());
            }
        }
    }

    public static void addWanderingTraderTrades(boolean rare, VillagerTrades.ITrade ... trades) {
        if (rare) {
            Collections.addAll(WANDERING_TRADER_RARES, trades);
        } else {
            Collections.addAll(WANDERING_TRADER_GENERICS, trades);
        }
    }

    @SubscribeEvent
    public static void registerWanderingTraderTrades(WandererTradesEvent event) {
        if (!WANDERING_TRADER_GENERICS.isEmpty()) {
            event.getGenericTrades().addAll(WANDERING_TRADER_GENERICS);
        }
        if (!WANDERING_TRADER_RARES.isEmpty()) {
            event.getRareTrades().addAll(WANDERING_TRADER_RARES);
        }
    }
}

