/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.forge;

import com.blackgear.platform.common.IntegrationHandler;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="platform", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class IntegrationHandlerImpl {
    private static final Set<Consumer<PlayerInteractEvent.RightClickBlock>> BLOCK_INTERACTIONS = ConcurrentHashMap.newKeySet();
    private static final Set<Consumer<FurnaceFuelBurnTimeEvent>> FUEL_ENTRIES = ConcurrentHashMap.newKeySet();

    public static void addInteraction(IntegrationHandler.Interaction interaction) {
        BLOCK_INTERACTIONS.add(event -> {
            ActionResultType result = interaction.of(new ItemUseContext((PlayerEntity)event.getEntity(), event.getHand(), event.getHitVec()));
            if (result != ActionResultType.PASS) {
                event.setCanceled(true);
                event.setCancellationResult(result);
            }
        });
    }

    @SubscribeEvent
    public static void registerBlockInteraction(PlayerInteractEvent.RightClickBlock event) {
        BLOCK_INTERACTIONS.forEach(consumer -> consumer.accept(event));
    }

    public static void addFuel(IItemProvider item, int burnTime) {
        FUEL_ENTRIES.add(event -> {
            if (event.getItemStack().func_77973_b() == item.func_199767_j()) {
                event.setBurnTime(burnTime);
            }
        });
    }

    @SubscribeEvent
    public static void registerFuel(FurnaceFuelBurnTimeEvent event) {
        FUEL_ENTRIES.forEach(consumer -> consumer.accept(event));
    }
}

