/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.providers.height;

import com.blackgear.platform.common.providers.height.HeightProvider;
import com.blackgear.platform.common.providers.height.HeightProviderType;
import com.blackgear.platform.common.worldgen.WorldGenerationContext;
import com.blackgear.platform.common.worldgen.height.VerticalAnchor;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BiasedToBottomHeight
extends HeightProvider {
    public static final Codec<BiasedToBottomHeight> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)VerticalAnchor.CODEC.fieldOf("min_inclusive").forGetter(provider -> provider.minInclusive), (App)VerticalAnchor.CODEC.fieldOf("max_inclusive").forGetter(provider -> provider.maxInclusive), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).optionalFieldOf("inner", (Object)1).forGetter(provider -> provider.inner)).apply((Applicative)instance, BiasedToBottomHeight::new));
    private static final Logger LOGGER = LogManager.getLogger();
    private final VerticalAnchor minInclusive;
    private final VerticalAnchor maxInclusive;
    private final int inner;

    private BiasedToBottomHeight(VerticalAnchor minInclusive, VerticalAnchor maxInclusive, int inner) {
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
        this.inner = inner;
    }

    public static BiasedToBottomHeight of(VerticalAnchor minInclusive, VerticalAnchor maxInclusive, int inner) {
        return new BiasedToBottomHeight(minInclusive, maxInclusive, inner);
    }

    @Override
    public int sample(Random random, WorldGenerationContext context) {
        int minY = this.minInclusive.resolveY(context);
        int maxY = this.maxInclusive.resolveY(context);
        if (maxY - minY - this.inner + 1 <= 0) {
            LOGGER.warn("Empty height range: {}", (Object)this);
            return minY;
        }
        int bound = random.nextInt(maxY - minY - this.inner + 1);
        return random.nextInt(bound + this.inner) + minY;
    }

    @Override
    public HeightProviderType<?> getType() {
        return HeightProviderType.BIASED_TO_BOTTOM;
    }

    public String toString() {
        return "biased[" + this.minInclusive + "-" + this.maxInclusive + " inner: " + this.inner + "]";
    }
}

