/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.providers.height;

import com.blackgear.platform.common.providers.height.HeightProvider;
import com.blackgear.platform.common.providers.height.HeightProviderType;
import com.blackgear.platform.common.worldgen.WorldGenerationContext;
import com.blackgear.platform.common.worldgen.height.VerticalAnchor;
import com.blackgear.platform.core.util.MathUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TrapezoidHeight
extends HeightProvider {
    public static final Codec<TrapezoidHeight> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)VerticalAnchor.CODEC.fieldOf("min_inclusive").forGetter(provider -> provider.minInclusive), (App)VerticalAnchor.CODEC.fieldOf("max_inclusive").forGetter(provider -> provider.maxInclusive), (App)Codec.INT.optionalFieldOf("plateau", (Object)0).forGetter(provider -> provider.plateau)).apply((Applicative)instance, TrapezoidHeight::new));
    private static final Logger LOGGER = LogManager.getLogger();
    private final VerticalAnchor minInclusive;
    private final VerticalAnchor maxInclusive;
    private final int plateau;

    private TrapezoidHeight(VerticalAnchor minInclusive, VerticalAnchor maxInclusive, int plateau) {
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
        this.plateau = plateau;
    }

    public static TrapezoidHeight of(VerticalAnchor minInclusive, VerticalAnchor maxInclusive, int plateau) {
        return new TrapezoidHeight(minInclusive, maxInclusive, plateau);
    }

    public static TrapezoidHeight of(VerticalAnchor minInclusive, VerticalAnchor maxInclusive) {
        return TrapezoidHeight.of(minInclusive, maxInclusive, 0);
    }

    @Override
    public int sample(Random random, WorldGenerationContext context) {
        int maxY;
        int minY = this.minInclusive.resolveY(context);
        if (minY > (maxY = this.maxInclusive.resolveY(context))) {
            LOGGER.warn("Empty height range: {}", (Object)this);
            return minY;
        }
        int heightRange = maxY - minY;
        if (this.plateau >= heightRange) {
            return MathUtils.randomBetweenInclusive(random, minY, maxY);
        }
        int lowerRange = (heightRange - this.plateau) / 2;
        int upperRange = heightRange - lowerRange;
        return minY + MathUtils.randomBetweenInclusive(random, 0, upperRange) + MathUtils.randomBetweenInclusive(random, 0, lowerRange);
    }

    @Override
    public HeightProviderType<?> getType() {
        return HeightProviderType.TRAPEZOID;
    }

    public String toString() {
        return this.plateau == 0 ? "triangle (" + this.minInclusive + "-" + this.maxInclusive + ")" : "trapezoid(" + this.plateau + ") in [" + this.minInclusive + "-" + this.maxInclusive + "]";
    }
}

