/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.providers.height;

import com.blackgear.platform.common.providers.height.HeightProvider;
import com.blackgear.platform.common.providers.height.HeightProviderType;
import com.blackgear.platform.common.worldgen.WorldGenerationContext;
import com.blackgear.platform.common.worldgen.height.VerticalAnchor;
import com.blackgear.platform.core.util.MathUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UniformHeight
extends HeightProvider {
    public static final Codec<UniformHeight> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)VerticalAnchor.CODEC.fieldOf("min_inclusive").forGetter(provider -> provider.minInclusive), (App)VerticalAnchor.CODEC.fieldOf("max_inclusive").forGetter(provider -> provider.maxInclusive)).apply((Applicative)instance, UniformHeight::new));
    private static final Logger LOGGER = LogManager.getLogger();
    private final VerticalAnchor minInclusive;
    private final VerticalAnchor maxInclusive;

    private UniformHeight(VerticalAnchor minInclusive, VerticalAnchor maxInclusive) {
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
    }

    public static UniformHeight of(VerticalAnchor minInclusive, VerticalAnchor maxInclusive) {
        return new UniformHeight(minInclusive, maxInclusive);
    }

    @Override
    public int sample(Random random, WorldGenerationContext context) {
        int maxY;
        int minY = this.minInclusive.resolveY(context);
        if (minY > (maxY = this.maxInclusive.resolveY(context))) {
            LOGGER.warn("Empty height range: {}", (Object)this);
            return minY;
        }
        return MathUtils.randomBetweenInclusive(random, minY, maxY);
    }

    @Override
    public HeightProviderType<?> getType() {
        return HeightProviderType.UNIFORM;
    }

    public String toString() {
        return "[" + this.minInclusive + "-" + this.maxInclusive + "]";
    }
}

